/*
 * Decompiled with CFR 0.152.
 */
package jbleu;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jbleu.util.Ngram;

public class JBLEU {
    private static final int N = 4;
    public static final String VERSION = "0.1.1";
    public int verbosity = 0;

    public JBLEU() {
    }

    public JBLEU(int verbosity) {
        this.verbosity = verbosity;
    }

    public static int pickReference(List<String> hyp, List<List<String>> refs, int verbosity) {
        int hypLen = hyp.size();
        int selectedRefLen = Integer.MAX_VALUE;
        int selectedRef = -1;
        int curDist = Integer.MAX_VALUE;
        int i = 0;
        for (List<String> ref : refs) {
            int myDist = Math.abs(hypLen - ref.size());
            if (myDist < curDist) {
                selectedRefLen = ref.size();
                selectedRef = i;
                curDist = myDist;
            } else if (myDist == curDist && ref.size() < selectedRefLen) {
                selectedRefLen = ref.size();
                selectedRef = i;
                curDist = myDist;
                if (verbosity >= 2) {
                    System.err.println(String.format("jBLEU: Picking more optimistic reference for brevity penalty: hyp_len = %d; ref_len = %d; distance = %d", hypLen, ref.size(), myDist));
                }
            }
            ++i;
        }
        return selectedRef;
    }

    public void stats(List<String> hyp, List<List<String>> refs, int[] result) {
        assert (result.length == 9);
        assert (refs.size() > 0);
        int selectedRef = JBLEU.pickReference(hyp, refs, this.verbosity);
        int selectedRefLen = refs.get(selectedRef).size();
        HashMultiset<Ngram> clippedRefNgrams = HashMultiset.create();
        for (List<String> ref : refs) {
            HashMultiset<Ngram> refNgrams = HashMultiset.create();
            for (int order = 1; order <= 4; ++order) {
                for (int i = 0; i <= ref.size() - order; ++i) {
                    List<String> toks = ref.subList(i, i + order);
                    Ngram ngram = new Ngram(toks);
                    refNgrams.add(ngram);
                }
            }
            for (Ngram ngram : refNgrams) {
                int clippedCount = Math.max(refNgrams.count(ngram), clippedRefNgrams.count(ngram));
                clippedRefNgrams.setCount(ngram, clippedCount);
            }
        }
        int[] attempts = new int[4];
        int[] matches = new int[4];
        for (int order = 1; order <= 4; ++order) {
            for (int i = 0; i <= hyp.size() - order; ++i) {
                List<String> toks = hyp.subList(i, i + order);
                Ngram ngram = new Ngram(toks);
                boolean found = clippedRefNgrams.remove(ngram);
                int n = order - 1;
                attempts[n] = attempts[n] + 1;
                if (!found) continue;
                int n2 = order - 1;
                matches[n2] = matches[n2] + 1;
            }
        }
        System.arraycopy(attempts, 0, result, 0, 4);
        System.arraycopy(matches, 0, result, 4, 4);
        result[8] = selectedRefLen;
    }

    private static double getAttemptedNgrams(int[] suffStats, int j) {
        return suffStats[j];
    }

    private static double getMatchingNgrams(int[] suffStats, int j) {
        return suffStats[j + 4];
    }

    private static double getRefWords(int[] suffStats) {
        return suffStats[8];
    }

    public double score(int[] suffStats) {
        return this.score(suffStats, null);
    }

    public double score(int[] suffStats, double[] allResults) {
        Preconditions.checkArgument(suffStats.length == 9, "BLEU sufficient stats must be of length N*2+1");
        double refWords = JBLEU.getRefWords(suffStats);
        double hypWords = JBLEU.getAttemptedNgrams(suffStats, 0);
        double brevityPenalty = hypWords < refWords ? Math.exp(1.0 - refWords / hypWords) : 1.0;
        assert (brevityPenalty >= 0.0);
        assert (brevityPenalty <= 1.0);
        if (this.verbosity >= 1) {
            System.err.println(String.format("jBLEU: Brevity penalty = %.6f (ref_words = %.0f, hyp_words = %.0f)", brevityPenalty, refWords, hypWords));
        }
        if (allResults != null) {
            assert (allResults.length == 5);
            allResults[4] = brevityPenalty;
        }
        double score = 0.0;
        double smooth = 1.0;
        for (int j = 0; j < 4; ++j) {
            double iscore;
            double attemptedNgramsJ = JBLEU.getAttemptedNgrams(suffStats, j);
            double matchingNgramsJ = JBLEU.getMatchingNgrams(suffStats, j);
            if (attemptedNgramsJ == 0.0) {
                iscore = 0.0;
                if (this.verbosity >= 1) {
                    System.err.println(String.format("jBLEU: %d-grams: raw 0/0 = 0 %%", j + 1));
                }
            } else if (matchingNgramsJ == 0.0) {
                double smoothedPrecision = 1.0 / ((smooth *= 2.0) * attemptedNgramsJ);
                iscore = Math.log(smoothedPrecision);
                if (this.verbosity >= 1) {
                    System.err.println(String.format("jBLEU: %d-grams: %.0f/%.0f = %.2f %% (smoothed) :: raw = %.2f %%", j + 1, matchingNgramsJ, attemptedNgramsJ, smoothedPrecision * 100.0, matchingNgramsJ / attemptedNgramsJ * 100.0));
                }
            } else {
                double precisionAtJ = matchingNgramsJ / attemptedNgramsJ;
                iscore = Math.log(precisionAtJ);
                if (this.verbosity >= 1) {
                    System.err.println(String.format("jBLEU: %d-grams: %.0f/%.0f = %.2f %% (unsmoothed)", j + 1, matchingNgramsJ, attemptedNgramsJ, precisionAtJ * 100.0));
                }
            }
            double ngramOrderWeight = 0.25;
            score += iscore * ngramOrderWeight;
            if (allResults == null) continue;
            assert (allResults.length == 5);
            allResults[j] = brevityPenalty * Math.exp(score);
        }
        double totalScore = brevityPenalty * Math.exp(score);
        if (totalScore > 1.0) {
            System.err.println("BLEU: Thresholding out of range score: " + totalScore + "; stats: " + Arrays.toString(suffStats));
            totalScore = 1.0;
        } else if (totalScore < 0.0) {
            System.err.println("BLEU: Thresholding out of range score: " + totalScore);
            totalScore = 0.0;
        }
        return totalScore;
    }

    public static int getSuffStatCount() {
        return 9;
    }

    public static void main(String[] args) {
        JBLEU bleu = new JBLEU();
        int[] result = new int[JBLEU.getSuffStatCount()];
        ArrayList<String> hyp = Lists.newArrayList(Splitter.on(' ').split("This is a hypothesis sentence ."));
        ArrayList<List<String>> refs = new ArrayList<List<String>>();
        refs.add(Lists.newArrayList(Splitter.on(' ').split("This is the first reference sentence .")));
        refs.add(Lists.newArrayList(Splitter.on(' ').split("This is the second reference sentence .")));
        bleu.stats(hyp, refs, result);
        System.err.println(Arrays.toString(result));
        System.err.println(bleu.score(result));
    }
}

