/*
 * Decompiled with CFR 0.152.
 */
package jannopts.util;

public class StringUtils {
    public static int countOccurancesOfSingleDelim(String searchable, String substring) {
        int nOccurances = 0;
        int nBegin = searchable.indexOf(substring);
        while (nBegin != -1) {
            ++nOccurances;
            int nEnd = nBegin + substring.length();
            nBegin = searchable.indexOf(substring, nEnd);
        }
        return nOccurances;
    }

    public static String[] split(String str, String delim, int nMaxSplits) {
        int nOccurances = Math.min(StringUtils.countOccurancesOfSingleDelim(str, delim) + 1, nMaxSplits);
        String[] tokens = new String[nOccurances];
        int nBegin = str.indexOf(delim);
        int nEnd = 0;
        int i = 0;
        while (i < nOccurances - 1) {
            tokens[i] = str.substring(nEnd, nBegin);
            nEnd = nBegin + delim.length();
            nBegin = str.indexOf(delim, nEnd);
            ++i;
        }
        if (nOccurances > 0) {
            tokens[tokens.length - 1] = str.substring(nEnd);
        }
        return tokens;
    }

    public static String substringAfter(String in, String delim, boolean returnDelims) {
        int nIndex = in.indexOf(delim);
        if (nIndex != -1 && nIndex < in.length()) {
            if (returnDelims) {
                return in.substring(nIndex);
            }
            return in.substring(nIndex + delim.length());
        }
        return in;
    }
}

