/*
 * Decompiled with CFR 0.152.
 */
package jannopts;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jannopts.ConfigurationException;
import jannopts.Option;
import jannopts.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator {
    private static final Logger log = Logger.getLogger(Configurator.class.getName());
    public static final Pattern WHITESPACE = Pattern.compile("[ \t]+");
    public static final Pattern NUMBERABLE = Pattern.compile("(.+?)([0-9]+)$");
    private Map<String, Option> nameToOption = new HashMap<String, Option>();
    private Map<String, Field> nameToField = new HashMap<String, Field>();
    private Map<String, Field> shortNameToField = new HashMap<String, Field>();
    private Set<String> requiredOptions = new HashSet<String>();
    private StringBuilder passedInOptions;
    private final Set<Class<?>> optionsClasses = new HashSet();
    private final Multimap<String, Class<?>> moduleOptionsClasses = ArrayListMultimap.create();
    private final Properties props = new Properties();
    private boolean failOnUnrecognized = true;
    private boolean ignoreUnrecog = false;
    private boolean requiresModule = false;
    private String programHeader = null;
    private String module;
    private Map<String, Option> numberableLongOptions = new HashMap<String, Option>();
    private Map<String, Option> numberableShortOptions = new HashMap<String, Option>();
    private Map<String, Map<String, Class<?>>> dynamicOpts = new HashMap();

    public Configurator failOnUnrecognized(boolean b) {
        this.failOnUnrecognized = b;
        return this;
    }

    public Configurator withProgramHeader(String programHeader) {
        this.programHeader = programHeader;
        return this;
    }

    public Configurator withOptions(Class<?> classWithOptions) {
        this.optionsClasses.add(classWithOptions);
        this.getOptionAnnotations(classWithOptions);
        return this;
    }

    public Configurator readFrom(String[] args) throws ConfigurationException {
        int firstArg = 0;
        if (this.requiresModule) {
            this.module = this.readModule(args);
            firstArg = 1;
        }
        Configurator.parseCommandLineArgs(args, firstArg, this.props);
        return this;
    }

    private String readModule(String[] args) throws ConfigurationException {
        Set<String> modules = this.moduleOptionsClasses.keySet();
        if (args.length < 1) {
            throw new ConfigurationException("No module specified. Valid module names are: " + modules);
        }
        String mod = args[0];
        if (!modules.contains(mod)) {
            throw new ConfigurationException("Invalid module name " + mod + "\nValid module names are: " + modules.toString());
        }
        return mod;
    }

    public Configurator readFrom(Properties externalProps) {
        this.props.putAll((Map<?, ?>)externalProps);
        return this;
    }

    public Configurator readFrom(Iterable<Map.Entry<String, String>> config) {
        for (Map.Entry<String, String> entry : config) {
            this.props.setProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public static void parseCommandLineArgs(String[] commandLineArgs, int firstArg, Properties props) throws ConfigurationException {
        int i = firstArg;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].startsWith("--")) {
                String propertyName = StringUtils.substringAfter(commandLineArgs[i], "--", false);
                if (i + 1 >= commandLineArgs.length) {
                    throw new ConfigurationException("No value specified on command line for property name " + propertyName);
                }
                StringBuilder propertyValue = new StringBuilder(commandLineArgs[i + 1]);
                int j = i + 2;
                while (j < commandLineArgs.length) {
                    if (commandLineArgs[j].startsWith("-")) break;
                    propertyValue.append(" " + commandLineArgs[j]);
                    ++j;
                }
                props.setProperty(propertyName, propertyValue.toString());
            }
            ++i;
        }
    }

    private void clear() {
        this.nameToOption = new HashMap<String, Option>();
        this.nameToField = new HashMap<String, Field>();
        this.requiredOptions = new HashSet<String>();
    }

    private void getOptionAnnotations(Class<?> optionsClass) {
        this.getOptionAnnotations(optionsClass, false);
    }

    private void getOptionAnnotations(Class<?> optionsClass, boolean stripRequired) {
        Field[] fieldArray = optionsClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Option option = field.getAnnotation(Option.class);
            if (option != null) {
                Field conflictField = this.nameToField.get(option.longName());
                if (conflictField != null && !conflictField.equals(field)) {
                    throw new RuntimeException("conflicting long name: " + option.longName() + " (conflict between " + conflictField.getDeclaringClass().getName() + " and " + field.getDeclaringClass().getName() + ")");
                }
                conflictField = this.shortNameToField.get(option.longName());
                if (conflictField != null && !conflictField.equals(field)) {
                    throw new RuntimeException("conflicting short name: " + option.shortName() + " (conflict between " + conflictField.getDeclaringClass().getName() + " and " + field.getDeclaringClass().getName() + ")");
                }
                this.nameToOption.put(option.longName(), option);
                this.nameToField.put(option.longName(), field);
                this.shortNameToField.put(option.shortName(), field);
                if (option.numberable()) {
                    this.numberableLongOptions.put(option.longName(), option);
                    this.numberableShortOptions.put(option.shortName(), option);
                }
                if (option.required() && !option.numberable() && !stripRequired) {
                    this.requiredOptions.add(option.longName());
                }
            }
            ++n2;
        }
    }

    public String getGlobalUsage() {
        StringBuilder usage = new StringBuilder();
        if (this.programHeader != null) {
            usage.append(String.valueOf(this.programHeader) + "\n\n");
        }
        usage.append("Usage: program ");
        if (this.requiresModule) {
            usage.append("<module_name> ");
        }
        usage.append("[options...]\n\n");
        for (Class<?> clazz : this.optionsClasses) {
            usage.append("=== " + clazz.getSimpleName() + " ===\n");
            this.printUsageForClass(usage, clazz);
        }
        for (Map.Entry entry : this.moduleOptionsClasses.entries()) {
            String moduleName = (String)entry.getKey();
            Class optionsClass = (Class)entry.getValue();
            usage.append("=== " + optionsClass.getSimpleName() + " (for " + moduleName + " module) ===\n");
            this.printUsageForClass(usage, optionsClass);
        }
        usage.append(String.format("%-30shelp message\n", "--help"));
        return usage.toString();
    }

    private void printUsageForClass(StringBuilder usage, Class<?> optionsClass) {
        this.clear();
        this.getOptionAnnotations(optionsClass);
        for (Option opt : this.nameToOption.values()) {
            usage.append(String.format("-%s %-30s %s ", opt.shortName(), "[--" + opt.longName() + "]", opt.usage()));
            if (!opt.required()) {
                usage.append(" [optional]");
            }
            usage.append("\n");
        }
        usage.append("\n");
    }

    public void validateConfiguration() throws ConfigurationException {
        this.validate();
    }

    public <X> void configure(X options) throws ConfigurationException {
        this.validateConfiguration();
        HashSet<String> seenOpts = new HashSet<String>();
        this.passedInOptions = new StringBuilder("{");
        this.configure(options.getClass(), seenOpts, options);
    }

    public <X> X getOptions(Class<X> optionsClass) {
        this.clear();
        this.getOptionAnnotations(optionsClass);
        return this.getOptions(optionsClass, true);
    }

    private <X> X getOptions(Class<X> optionsClass, boolean dummy) {
        try {
            HashSet<String> seenOpts = new HashSet<String>();
            this.passedInOptions = new StringBuilder("{");
            X options = optionsClass.newInstance();
            this.configure(optionsClass, seenOpts, options);
            return options;
        }
        catch (IllegalArgumentException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (SecurityException e) {
            throw new Error(e);
        }
    }

    private <X> void configure(Class<?> optionsClass, Set<String> seenOpts, X options) {
        try {
            for (String key : this.nameToOption.keySet()) {
                Option opt = this.nameToOption.get(key);
                if (!Configurator.hasDefault(opt)) continue;
                String defaultValue = opt.defaultValue();
                try {
                    this.setValue(options, key, defaultValue, opt);
                    seenOpts.add(key);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class not found while parsing option required by " + optionsClass.getSimpleName() + ": " + key + " = " + defaultValue + "\n" + e.getMessage());
                }
            }
            HashSet<String> handledNumberableOptions = new HashSet<String>();
            for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Option opt = this.nameToOption.get(key);
                if (opt == null) {
                    opt = this.matchNumberableOption(key);
                    String keyPrefix = opt.longName();
                    if (handledNumberableOptions.contains(keyPrefix)) continue;
                    handledNumberableOptions.add(keyPrefix);
                    try {
                        List<String> values = Configurator.grabValues(this.props, keyPrefix);
                        this.setNumberableValue(options, keyPrefix, values, opt);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Class not found while parsing option required by " + optionsClass.getSimpleName() + ": " + key + " = " + value + "\n" + e.getMessage());
                    }
                }
                try {
                    this.setValue(options, key, value, opt);
                    seenOpts.add(key);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class not found while parsing option required by " + optionsClass.getSimpleName() + ": " + key + " = " + value + "\n" + e.getMessage());
                }
            }
            HashSet<String> optionsLeft = new HashSet<String>(this.requiredOptions);
            optionsLeft.removeAll(seenOpts);
            if (!optionsLeft.isEmpty()) {
                System.err.println(this.getGlobalUsage());
                System.err.println("Failed to specify required options: " + optionsLeft);
                System.exit(1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new Error(e);
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (SecurityException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
    }

    private Option matchNumberableOption(String key) {
        Matcher numMatcher = NUMBERABLE.matcher(key);
        Option opt = null;
        if (numMatcher.matches()) {
            String keyPrefix = numMatcher.group(1);
            opt = this.numberableLongOptions.get(keyPrefix);
        }
        return opt;
    }

    private static List<String> grabValues(Properties props, String keyPrefix) {
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        int sz = 0;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher numMatcher = NUMBERABLE.matcher(key);
            if (!numMatcher.matches()) continue;
            keyPrefix = numMatcher.group(1);
            int n = Integer.parseInt(numMatcher.group(2));
            sz = Math.max(sz, n);
            values.put(n, value);
        }
        ArrayList<String> list = new ArrayList<String>(sz);
        int i = 1;
        while (i <= sz) {
            String value = (String)values.get(i);
            if (value == null) {
                throw new RuntimeException("Expecting options ranging from " + keyPrefix + "1 - " + keyPrefix + sz + " based on flags, but didn't find a flag for " + keyPrefix + i);
            }
            list.add(value);
            ++i;
        }
        return list;
    }

    private Object create(Class<?> fieldType, Type genType, String key, String value, Option opt) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Serializable obj = null;
        if (fieldType == File.class) {
            File f = new File(value);
            if (opt.errorIfFileExists() && f.exists()) {
                throw new RuntimeException("File for " + key + " already exists: " + f.getAbsolutePath());
            }
            if (opt.errorIfFileNotExists() && !f.exists()) {
                throw new RuntimeException("File for " + key + " does not exist: " + f.getAbsolutePath());
            }
            obj = f;
        } else if (fieldType == Class.class) {
            obj = Class.forName(value);
        } else {
            try {
                Constructor<?> constructor = fieldType.getConstructor(String.class);
                obj = constructor.newInstance(value);
            }
            catch (NoSuchMethodException e) {
                throw new Error("Cannot construct object of type " + fieldType.getCanonicalName() + " from just a string", e);
            }
            catch (InstantiationException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                throw new Error(e);
            }
        }
        return obj;
    }

    private <X> void setNumberableValue(X options, String keyPrefix, List<String> values, Option opt) throws NoSuchMethodException, InstantiationException, InvocationTargetException, Error, IllegalArgumentException, SecurityException, ClassNotFoundException {
        Field field = this.nameToField.get(keyPrefix);
        try {
            Class<?> fieldType = field.getType();
            field.setAccessible(true);
            if (!fieldType.isArray()) {
                throw new RuntimeException("Numberable options must have array type.");
            }
            Type genericComponentType = field.getGenericType() instanceof GenericArrayType ? ((GenericArrayType)field.getGenericType()).getGenericComponentType() : fieldType.getComponentType();
            Object arr = Array.newInstance(fieldType.getComponentType(), values.size());
            int i = 0;
            while (i < values.size()) {
                String value = values.get(i);
                if (fieldType.getComponentType() == Integer.TYPE) {
                    Array.set(arr, i, Integer.parseInt(value));
                } else if (fieldType.getComponentType() == Double.TYPE) {
                    Array.set(arr, i, Double.parseDouble(value));
                } else if (fieldType.getComponentType() == Float.TYPE) {
                    Array.set(arr, i, Float.valueOf(Float.parseFloat(value)));
                } else if (fieldType.getComponentType() == Short.TYPE) {
                    Array.set(arr, i, Short.parseShort(value));
                } else if (fieldType.getComponentType() == Boolean.TYPE) {
                    Array.set(arr, i, Boolean.parseBoolean(value));
                } else {
                    Object arrayElement = this.create(fieldType.getComponentType(), genericComponentType, keyPrefix, value, opt);
                    Array.set(arr, i, arrayElement);
                }
                ++i;
            }
            field.set(options, arr);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not set field " + field.getName() + " in " + options.getClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            new RuntimeException("Could not set field " + field.getName() + " in " + options.getClass().getName() + " to " + values, e);
        }
    }

    private <X> void setValue(X options, String key, String strValue, Option opt) throws NoSuchMethodException, InstantiationException, InvocationTargetException, Error, IllegalArgumentException, SecurityException, ClassNotFoundException {
        block27: {
            Field field = this.nameToField.get(key);
            try {
                Class<?> fieldType = field.getType();
                field.setAccessible(true);
                if (strValue != null) {
                    strValue.trim();
                }
                if (fieldType == Integer.TYPE) {
                    field.setInt(options, Integer.parseInt(strValue));
                    break block27;
                }
                if (fieldType == Double.TYPE) {
                    field.setDouble(options, Double.parseDouble(strValue));
                    break block27;
                }
                if (fieldType == Float.TYPE) {
                    field.setFloat(options, Float.parseFloat(strValue));
                    break block27;
                }
                if (fieldType == Short.TYPE) {
                    field.setFloat(options, Short.parseShort(strValue));
                    break block27;
                }
                if (fieldType == Boolean.TYPE) {
                    field.setBoolean(options, Boolean.parseBoolean(strValue));
                    break block27;
                }
                if (fieldType.isEnum()) {
                    ?[] possibleValues = fieldType.getEnumConstants();
                    boolean found = false;
                    ?[] objArray = possibleValues;
                    int n = possibleValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object possibleValue = objArray[n2];
                        String enumName = ((Enum)possibleValue).name();
                        if (strValue.equals(enumName)) {
                            field.set(options, possibleValue);
                            found = true;
                            break block27;
                        }
                        ++n2;
                    }
                    break block27;
                }
                if (fieldType == String.class) {
                    field.set(options, strValue);
                } else if (fieldType.isArray()) {
                    String[] toks = StringUtils.split(strValue, opt.arrayDelim(), Integer.MAX_VALUE);
                    Type genericComponentType = field.getGenericType() instanceof GenericArrayType ? ((GenericArrayType)field.getGenericType()).getGenericComponentType() : fieldType.getComponentType();
                    Object arr = Array.newInstance(fieldType.getComponentType(), toks.length);
                    int i = 0;
                    while (i < toks.length) {
                        String tok = toks[i];
                        if (fieldType.getComponentType() == Integer.TYPE) {
                            Array.set(arr, i, Integer.parseInt(tok));
                        } else if (fieldType.getComponentType() == Double.TYPE) {
                            Array.set(arr, i, Double.parseDouble(tok));
                        } else if (fieldType.getComponentType() == Float.TYPE) {
                            Array.set(arr, i, Float.valueOf(Float.parseFloat(tok)));
                        } else if (fieldType.getComponentType() == Short.TYPE) {
                            Array.set(arr, i, Short.parseShort(tok));
                        } else if (fieldType.getComponentType() == Boolean.TYPE) {
                            Array.set(arr, i, Boolean.parseBoolean(tok));
                        } else {
                            Object arrayElement = this.create(fieldType.getComponentType(), genericComponentType, key, tok, opt);
                            Array.set(arr, i, arrayElement);
                        }
                        ++i;
                    }
                    field.set(options, arr);
                } else {
                    Object obj = this.create(fieldType, field.getGenericType(), key, strValue, opt);
                    field.set(options, obj);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not set field " + field.getName() + " in " + options.getClass().getName(), e);
            }
            catch (IllegalArgumentException e) {
                new RuntimeException("Could not set field " + field.getName() + " in " + options.getClass().getName() + " to " + strValue, e);
            }
        }
    }

    private void validate() throws ConfigurationException {
        String key;
        HashSet<String> seenOpts = new HashSet<String>();
        this.passedInOptions = new StringBuilder("{");
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option opt = this.nameToOption.get(key);
            if (opt == null) {
                opt = this.matchNumberableOption(key);
                if (opt != null) {
                    key = opt.longName();
                } else {
                    if (this.failOnUnrecognized && !this.ignoreUnrecog) {
                        throw new ConfigurationException("Did not recognize option " + key);
                    }
                    if (this.ignoreUnrecog) continue;
                    log.warning("Did not recognize option " + key);
                    continue;
                }
            }
            seenOpts.add(key);
        }
        for (Map.Entry<Object, Object> entry : this.nameToOption.entrySet()) {
            key = (String)entry.getKey();
            Option option = (Option)entry.getValue();
            if (!Configurator.hasDefault(option)) continue;
            seenOpts.add(key);
        }
        HashSet<String> hashSet = new HashSet<String>(this.requiredOptions);
        hashSet.removeAll(seenOpts);
        if (!hashSet.isEmpty()) {
            System.err.println(this.getGlobalUsage());
            System.err.println("Failed to specify required options: " + hashSet);
            System.exit(1);
        }
    }

    private static boolean hasDefault(Option option) {
        return !option.defaultValue().equals("{{{JANNOPTS_DEFAULT_VALUE}}}");
    }

    public String getPassedInOptions() {
        return this.passedInOptions.toString();
    }

    public void printUsageTo(PrintStream err) {
        err.println(this.getGlobalUsage());
    }

    public Properties getProperties() {
        return this.props;
    }

    public Configurator withModuleOptions(String moduleName, Class<?> classWithOptions) {
        this.requiresModule = true;
        this.moduleOptionsClasses.put(moduleName, classWithOptions);
        this.getOptionAnnotations(classWithOptions);
        return this;
    }

    public void allowDynamicOptions(Class<?> classWithOptions) {
        this.optionsClasses.add(classWithOptions);
        this.getOptionAnnotations(classWithOptions, true);
    }

    public void activateDynamicOptions(Class<?> classWithOptions) {
        this.getOptionAnnotations(classWithOptions, false);
    }

    public String getModule() {
        return this.module;
    }

    public InputStream getHadoopConfigStream() throws IOException {
        File tmp = File.createTempFile(Configurator.class.getName(), ".conf.xml");
        System.err.println(tmp.getAbsolutePath());
        PrintWriter out = new PrintWriter(tmp);
        out.println("<configuration>");
        for (Object k : this.props.keySet()) {
            String key = (String)k;
            String value = this.props.getProperty(key);
            out.println(String.format("<property><name>%s</name><value>%s</value></property>", key, value));
        }
        out.println("</configuration>");
        out.close();
        return new FileInputStream(tmp);
    }

    public Configurator ignoreUnrecognized(boolean b) {
        this.ignoreUnrecog = true;
        return this;
    }
}

