/*
 * Decompiled with CFR 0.152.
 */
package jannopts;

import jannopts.Configurator;
import jannopts.Option;
import jannopts.validators.RangeCheck;
import java.util.Arrays;
import org.junit.Test;

public class ConfiguratorTest {
    @Option(shortName="n", longName="integer", usage="Hi, I'm an integer", defaultValue="1")
    @RangeCheck(lowest=0, highest=5)
    public int n;
    @Option(shortName="a", longName="arr", usage="I'm an array option", defaultValue="one two three", arrayDelim=" ")
    public String[] arr;
    @Option(shortName="N", longName="numberable", usage="I'm a numberable array option", numberable=true)
    public String[] numberable;

    @Test
    public void test() {
    }

    public static void main(String[] args) throws Exception {
        ConfiguratorTest inst = new ConfiguratorTest();
        Configurator opts = new Configurator().failOnUnrecognized(true).withOptions(inst.getClass()).readFrom(args);
        opts.validateConfiguration();
        opts.configure(inst);
        opts.printUsageTo(System.err);
        System.out.println("n=" + inst.n);
        System.out.println("a=" + Arrays.toString(inst.arr));
        System.out.println("N=" + Arrays.toString(inst.numberable));
        if (inst.n > 0) {
            OtherRequirements otherOpts = new OtherRequirements();
            opts.withOptions(otherOpts.getClass());
            opts.validateConfiguration();
            opts.configure(otherOpts);
        }
    }

    public static class OtherRequirements {
        @Option(shortName="p", longName="somethingElse", usage="Hi, I'm an integer", defaultValue="1")
        @RangeCheck(lowest=0, highest=5)
        public int n;
    }
}

