What directives are available in Ducttape?
==========================================

* ducttape_output: Specify the output directory for your workflow

* ducttape_unused_vars: What should we do when we detect an unused variable? Values: ignore|warn|error

* ducttape_undeclared_vars: What should we do when we detect an undeclared variable? Values: ignore|warn|error

* ducttape_experimental_imports: Enable imports. Syntax and semantics are subject to change.

* ducttape_experimental_packages: We are planning on making minor changes to the package syntax in a future release.

* ducttape_experimental_submitters: We are planning on making significant changes to the submitter syntax in a future release.



Why are tasks more like Make targets than functions?
====================================================

Because you typically only use them once, even over a large number
of experimental comparisons (thanks to branch points). Really,
you should be thinking about bash scripts and their arguments
as the basic unit of reusable functions in ducttape.

Coming soon: A nice big example.

Job control
===========

Q. What if I want to change the structure of a workflow while it is running?
A. No problem. Any tasks that are currently running will always continue to run. All other tasks defined in the previous version of the workflow, but not defined by the new version of the workflow will be cancelled by default (this can be overridden -- it might be useful to override if you want to submit several different sets of one-off experiments). Tasks that were defined in the old version of the workflow and are now redefined by new version of the workflow workflow will replace their old definitions (therefore, the old version of the tasks and all of its dependencies will be cancelled).

Why? Ducttape workflows are submitted to an always-running daemon. There is always one daemon per machine, and you are responsible for making sure you submit jobs from one head node per cluster (ducttape makes some attemps to complain if multiple daemons are pointed at the same directory on a shared filesystem).

Q. What if I want to change the input files to a workflow while it is running?
A. Ducttape can't guarantee the success of doing this *while* the workflow is running. A currently-executing step might be using the file you intend to replace. If you're confident this is not the case, go for it. But we warned. See below for details on switching out input files.

Q. What if I want to change the input files when a workflow is partially completed / between runs?
A. Just as ducttape manages the versions of the software packages in your workflow, it also checks if file versions differ (via a SHA1 or other heuristics). If they differ, you have 2 options: 1) Instruct ducttape to invalidate and rerun all tasks (and dependents) that use the changed input or 2) Instruct ducttape to ignore the change. In the latter case, ducttape will remember the change and keep a note of it (in case you notice strange inconsistencies later).

TODO: Make example inputs workflows that are part of the tutorial instead of just throwing words at this issue. (These are then unit tests as well).
