#!/usr/bin/perl

# extract.pl
# ----------
# Extracts twelf code from a suitable LaTeX
# file and stuffs it into a directory extract/
# Usage:
#  extract.pl final-paper.ltx
#
# Directives:
# \begin{verbatim}       \begin{twelf}
# ... code ...      or   ... code ...
# \end{verbatim}         \end{twelf}
#            Put ... code ... into the current output file.
# %!% file FILENAME
#            Set the current output file to extract/FILENAME.
# %!% blank
#            Emit a blank line
# %!% suppress
#            Ignore the next verbatim/twelf block.

my $dir = "extract";
system "mkdir $dir" unless -e $dir;
my $filename = undef;
my $printing = 0;
my $suppress = 0;
my $record = qr((?:verbatim|twelf));

sub print_to_file {
  if (defined $filename) {
	$content{$filename} .= join("", @_);
  }
}

while(<>) {
  chomp;
  if (s/^%!%\s+//) {
	my (@cmd) = split;
	if ($cmd[0] eq "file") {
	  $filename = $cmd[1];
	  next;
	}
	if ($cmd[0] eq "suppress") {
	  # Suppress printing of the next verbatim env
	  $suppress = 1;
	  next;
	}
	if ($cmd[0] eq "blank") {
	  print_to_file("\n");
	  next;
	}
	die "Unknown control command `$cmd[0]'";
  }
  if (/\\begin{$record}/) {
	if ($suppress) {
	  $suppress = 0;
	}
	else {
	  $printing = 1;
	}
	next;
  }
  if (/\\end{$record}/) {
	$printing = 0;
	next;
  }
  if ($printing) {
	print_to_file("$_\n");
  }
}

for (keys %content) {
  open OUT, ">$dir/$_" or die $!;
  print OUT $content{$_};
}
