#include <stdio.h>
#include <stdlib.h>



/* expected input data format                 */
/*                                            */
/* Time (sec)  packet_length (bytes)          */             
/*                                            */

/* output data format                         */
/*                                            */
/* Time (sec)  average_bwidth (Mbps)          */             
/*                                            */


void main(int argc, char **argv) {
  FILE *df;
  FILE *of;
  char data[30];
  char pointer[50];
  int  ival, first = 1;
  float start_time, ctime, time, time_t, time_int, pkt_len, 
    total_pkt_len = 0.0;
  
  if (argc != 5) {
    printf("Ussage: %s src dest start_time(sec) time_interval(ms)\n", argv[0]);
    exit(-1);
  }

  if (!(df = fopen (argv[1], "r"))) {
    printf ("fopen() failed\n");
    exit (1);
  }

  if (!(of = fopen (argv[2], "w"))) {
    printf ("fopen() failed\n");
    exit (1);
  }

  ival = atoi(argv[3]);
  start_time = (float)ival;

  ival = atoi(argv[4]);
  time_int = (float)ival/1000.;

  while (!feof(df)) {

    fscanf(df, "%f %f\n", &time, &pkt_len);

    if (first) {
      time_t = start_time + time_int;
      total_pkt_len = 0.0;
      first = 0;
    }

  repeat:
    if (time > time_t) {
      fprintf(of, "%f %f\n", time_t - start_time, 
        (float)total_pkt_len*8./(1000000.*time_int));
      total_pkt_len = 0.0;
      time_t += time_int;
      goto repeat;
    } else {
      total_pkt_len += pkt_len;
      if (time < time_t)
        continue;
      else {
        fprintf(of, "%f %f\n", time_t - start_time,
          (float)total_pkt_len*8./(1000000.*time_int));
        total_pkt_len = 0.0;
        time_t += (float)time_int;
      }
    }
  }

  fprintf(of, "%f %f\n", time_t - start_time, 
          (float)total_pkt_len*8./(1000000.*time_int));

  fclose(df);
  fclose(of);
}

  

