#include <stdio.h>
#include <stdlib.h>



/* expected input data format                 */
/*                                            */
/* file with a fixed number of columns        */             
/*                                            */

/* output data format                         */
/*                                            */
/* input file, but with all elements of the   */             
/* specified column multiplied/added/         */
/* substracted/divide by a specified constant */
/*                                            */


#define ADD 1
#define SUB 2
#define MUL 3
#define DIV 4

void main(int argc, char **argv) {
  FILE *df;
  FILE *of;
  char dummy[50];
  int  col_idx, num_cols, i, op_type = -1;
  float c, val;
  
  if (argc != 7) {
    printf("Ussage: %s src dest num_cols col_idx {add/div/mul/sub} const\n", argv[0]);
    exit(-1);
  }

  if (!(df = fopen (argv[1], "r"))) {
    printf ("fopen() failed\n");
    exit (1);
  }

  if (!(of = fopen (argv[2], "w"))) {
    printf ("fopen() failed\n");
    exit (1);
  }

  num_cols = atoi(argv[3]);
  col_idx = atoi(argv[4]);

  if (!strcmp(argv[5], "add")) 
    op_type = ADD;
  else if (!strcmp(argv[5], "sub"))  
    op_type = SUB;
  else if (!strcmp(argv[5], "mul"))  
    op_type = MUL;
  else if (!strcmp(argv[5], "div"))  
    op_type = DIV;
  else {
    puts("Inavlid operation !\n");\
    exit -1;
  }

  c = atof(argv[6]);

  while (!feof(df)) {

    for (i = 0; i < col_idx - 1; i++) {
      fscanf(df, "%s", dummy);
      fprintf(of, "%s ", dummy);
    }

    fscanf(df, "%f", &val);

    if (op_type == ADD) 
      fprintf(of, "%f ", val + c);
    else if (op_type == SUB) 
      fprintf(of, "%f ", val - c);
    else if (op_type == MUL) 
      fprintf(of, "%f ", val * c);
    else
      fprintf(of, "%f ", val / c);

    for (i = col_idx - 1; i < num_cols - 1; i++) {
      fscanf(df, "%s", dummy);
      fprintf(of, "%s ", dummy);
    }
    fscanf(df, "\n", dummy);
    fprintf(of, "\n", dummy);
  } 

  fclose(df);
  fclose(of);
}

  

