
Simulator instproc get-link { node1 node2 } {
    $self instvar link_
    set id1 [$node1 id]
    set id2 [$node2 id]
    return $link_($id1:$id2)
}

Simulator instproc get-queue { node1 node2 } {
    global ns
    set l [$ns get-link $node1 $node2]
    set q [$l queue]
    return $q
}

# bufThresh and bufSize are in bytes, rate in bps, delay and K in ms
proc build-csfq-link { src dest rate delay edge_fwd edge_bwd bufSize bufThresh pktSize K } {
    global ns

    $ns duplex-link $src $dest $rate [expr $delay/1000.] CSFQ
    $ns queue-limit $src $dest [expr $bufSize / $pktSize]
    $ns queue-limit $dest $src [expr $bufSize / $pktSize]

    set l [$ns get-link $src $dest]
    set q [$l queue]

    # set bufThreshold to half of total buffer size
    set bufThresh [expr $bufSize / 2]

    # init link related parameters: 
    # edge_ (0 or 1)
    # kLink_ (usec) 
    # qsize_ (bits)
    # qsizeThresh_ (bits) 
    # rate_ (bps)
    $q set id_ 1
    $q init-link $edge_fwd [expr $K*1000] [expr 8*$bufSize] [expr 8*$bufThresh] $rate
    # set link parameters in the reverse direction
    set l [$ns get-link $dest $src]
    set q [$l queue]
    $q init-link $edge_bwd [expr $K*1000] [expr 8*$bufSize] [expr 8*$bufThresh] $rate
}   

proc set-csfq-queue { src dest flowId weight kf } {
    global ns
    
    set l [$ns get-link $src $dest]
    set q [$l queue]

    # init flows: flowid, weight_, k_ (usec)
    $q init-flow $flowId $weight [expr $kf*1000]
}

# rate in bps, delay in ms, bufSize and pktSize in bytes
proc build-fifo-link { src dest rate delay bufSize pktSize } {
    global ns

    $ns duplex-link $src $dest $rate [expr $delay/1000.] DropTail
    $ns queue-limit $src $dest [expr $bufSize / $pktSize]
    $ns queue-limit $dest $src [expr $bufSize / $pktSize]
}
    

# rate in bps, delay in ms, bufSize and pktSize in bytes
proc build-red-link { src dest rate delay bufSize bufThresh pktSize } {
    global ns

    $ns duplex-link $src $dest $rate [expr $delay/1000.] RED
    $ns queue-limit $src $dest [expr $bufSize / $pktSize]
    $ns queue-limit $dest $src [expr $bufSize / $pktSize]

    set l [$ns get-link $src $dest]
    set q [$l queue]
    
    $q set mean_pktsize_ $pktSize
    $q set thresh_       [expr $bufThresh / $pktSize]
    $q set maxthresh_    [expr 2*$bufThresh / $pktSize]
}
    
# rate in bps, delay in ms, bufSize and pktSize in bytes
proc build-fred-link { src dest rate delay bufSize bufThresh pktSize } {
    global ns

    $ns duplex-link $src $dest $rate [expr $delay/1000.] FRED
    $ns queue-limit $src $dest [expr $bufSize / $pktSize]
    $ns queue-limit $dest $src [expr $bufSize / $pktSize]

    set l [$ns get-link $src $dest]
    set q [$l queue]
    
    $q set mean_pktsize_ $pktSize
    $q set thresh_       [expr $bufThresh / $pktSize]
    $q set maxthresh_    [expr 2*$bufThresh / $pktSize]
    $q set many-flows_   0
}
    
# rate in bps, delay in ms, bufSize and pktSize in bytes
proc build-fredl-link { src dest rate delay bufSize bufThresh pktSize } {
    global ns

    $ns duplex-link $src $dest $rate [expr $delay/1000.] FRED
    $ns queue-limit $src $dest [expr $bufSize / $pktSize]
    $ns queue-limit $dest $src [expr $bufSize / $pktSize]

    set l [$ns get-link $src $dest]
    set q [$l queue]
    
    $q set mean_pktsize_ $pktSize
    $q set thresh_       [expr $bufThresh / $pktSize]
    $q set maxthresh_    [expr 2*$bufThresh / $pktSize]
    $q set many-flows_   1
}
    
# rate in bps, delay in ms, bufSize and pktSize in bytes
proc build-drr-link { src dest rate delay bufSize pktSize } {
    global ns

    $ns duplex-link $src $dest $rate [expr $delay/1000.] DRR
    $ns queue-limit $src $dest [expr $bufSize / $pktSize]
    $ns queue-limit $dest $src [expr $bufSize / $pktSize]

    set l [$ns get-link $src $dest]
    set q [$l queue]
    
    $q quantum $pktSize
    $q blimit  $bufSize
    $q set buckets_ 200
}


    
# rate in bps, delay in ms, bufSize and pktSize in bytes
proc build-link { type src dest rate delay edge_fwd edge_bwd bufSize bufThresh pktSize K } {
  
 if { $type == "fifo" } {
    build-fifo-link $src $dest $rate $delay $bufSize $pktSize
  } elseif { $type == "red" } {
     build-red-link $src $dest $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fred" } {
    build-fred-link $src $dest $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fredl" } {
    build-fredl-link $src $dest $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "drr" } {
    build-drr-link $src $dest $rate $delay $bufSize $pktSize
  } elseif { $type == "csfq" } {
    build-csfq-link $src $dest $rate $delay $edge_fwd $edge_bwd $bufSize $bufThresh $pktSize $K
  } 
}
