set ns [new Simulator]

#
#
#  ( c[0], c[1], .., c[nFlows - 1] ) n0 --- n1
#
#

set f [open out.tr w]
$ns trace-all $f

# 
Queue/CSFQ set id_ 0
# in usec
Queue/CSFQ set kLink_ 50000
# 0 or 1
Queue/CSFQ set edge_  1
# queue size (bits)
Queue/CSFQ set qsize_ 400000
# queue threshold (bits)
Queue/CSFQ set qsizeThresh_ 80000
# in bps
Queue/CSFQ set rate_ 10000

set pktSize    1000
set startTime  0.
set finishTime 10.
set delay      1.
set K          100
set kf         100
set rate       1e+07
set tcpType    TCP

source ../my_sources.tcl
source ../my_links.tcl

# build topology
proc build-topology-oneudp { type nFlows delay K kf bufSize bufThresh pktSize startTime } {
  global ns
  global rate
  global tcpType

  # build link 
  set n0 [$ns node]
  set n1 [$ns node]

  if { $type == "fifo" } {
    build-fifo-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "red" } {
     build-red-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fred" } {
    build-fred-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fredl" } {
    build-fredl-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "drr" } {
    build-drr-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "csfq" } {
    build-csfq-link $n0 $n1 $rate $delay 1 1 $bufSize $bufThresh $pktSize $K
  }        


  # build udp
  if { $type == "drr" } {
    set new 2
    set n($new) [$ns node]
    build-drr-link $n($new) $n0 $rate $delay $bufSize $pktSize
    build-cbr $n($new) $n1 $pktSize [expr $pktSize*8/$rate] 1 0 $startTime
  } else {
    build-cbr $n0 $n1 $pktSize [expr $pktSize*8/$rate] 1 0 [expr $startTime + 0.001]
  }

  for {set i 1} {$i < $nFlows} {incr i} {

    # build tcp source
    if { $type == "drr" } {

      set new [expr $new + 1]
      set n($new) [$ns node]
      build-drr-link $n($new) $n0 $rate $delay $bufSize $pktSize
      build-tcp $tcpType $n($new) $n1 $pktSize 0 $i [expr $startTime + $i*0.001]
    
    } else {
      build-tcp $tcpType $n0 $n1 $pktSize 0 $i [expr $startTime + $i*0.001]
     
    } 
  }
  
  if { $type == "csfq" } {
    # init flows: flowid, weight_, k_ (usec)
    for {set i 0} {$i < $nFlows} {incr i} {
      set-csfq-queue $n0 $n1 $i 1 $kf
    }
  }
}



# build topology
proc build-topology-alludp { type nFlows delay K kf bufSize bufThresh pktSize startTime } {
  global ns
  global rate
  global tcpType

  # build link 
  set n0 [$ns node]
  set n1 [$ns node]

  if { $type == "fifo" } {
    build-fifo-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "red" } {
     build-red-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fred" } {
    build-fred-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fredl" } {
    build-fredl-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "drr" } {
    build-drr-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "csfq" } {
    build-csfq-link $n0 $n1 $rate $delay 1 1 $bufSize $bufThresh $pktSize $K
  }        


  set new 2

  for {set i 0} {$i < $nFlows} {incr i} {

    # build udp source
    if { $type == "drr" } {

      set new [expr $new + 1]
      set n($new) [$ns node]
      build-drr-link $n($new) $n0 $rate $delay $bufSize $pktSize

      build-cbr $n($new) $n1 $pktSize [expr $nFlows*$pktSize*8/(($i + 1)*$rate)] 1 $i [expr $startTime + $i*0.001]

    } else {

      build-cbr $n0 $n1 $pktSize [expr $nFlows*$pktSize*8/(($i + 1)*$rate)] 1 $i [expr $startTime + $i*0.001]
    }
  }

  if { $type == "csfq" } {
    # init flows: flowid, weight_, k_ (usec)
    for {set i 0} {$i < $nFlows} {incr i} {
      set-csfq-queue $n0 $n1 $i 1 $kf
    }
  }
} 
  

# build topology
proc build-topology-onetcp { type nFlows delay K kf bufSize bufThresh pktSize startTime } {
  global ns
  global rate
  global tcpType

  # build link 
  set n0 [$ns node]
  set n1 [$ns node]

  if { $type == "fifo" } {
    build-fifo-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "red" } {
     build-red-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fred" } {
    build-fred-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fredl" } {
    build-fredl-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "drr" } {
    build-drr-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "csfq" } {
    build-csfq-link $n0 $n1 $rate $delay 1 1 $bufSize $bufThresh $pktSize $K
  }        

  # build tcp 
  if { $type == "drr" } {
    set new 2
    set n($new) [$ns node]
    build-drr-link $n($new) $n0 $rate $delay $bufSize $pktSize
    build-tcp $tcpType $n($new) $n1 $pktSize 0 0 [expr $startTime + 0.001]

  } else {

      build-tcp $tcpType $n0 $n1 $pktSize 0 0 [expr $startTime + 0.001]
  }

  for {set i 1} {$i < $nFlows} {incr i} {

    # build udp source
    if { $type == "drr" } {

      set new [expr $new + 1]
      set n($new) [$ns node]
      build-drr-link $n($new) $n0 $rate $delay $bufSize $pktSize
      build-cbr $n($new) $n1 $pktSize [expr ($nFlows*$pktSize*4)/$rate] 1 $i [expr $startTime + $i*0.001]

    } else {
      build-cbr $n0 $n1 $pktSize [expr ($nFlows*$pktSize*4)/$rate] 1 $i [expr $startTime + $i*0.001]
    }
  }

  if { $type == "csfq" } {
    # init flows: flowid, weight_, k_ (usec)
    for {set i 0} {$i < $nFlows} {incr i} {
      set-csfq-queue $n0 $n1 $i 1 $kf
    }
  }
}


# build topology
proc build-topology-alltcp { type nFlows delay K kf bufSize bufThresh pktSize startTime } {
  global ns
  global rate
  global tcpType

  # build link 
  set n0 [$ns node]
  set n1 [$ns node]

  if { $type == "fifo" } {
    build-fifo-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "red" } {
     build-red-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fred" } {
    build-fred-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "fredl" } {
    build-fredl-link $n0 $n1 $rate $delay $bufSize $bufThresh $pktSize
  } elseif { $type == "drr" } {
    build-drr-link $n0 $n1 $rate $delay $bufSize $pktSize
  } elseif { $type == "csfq" } {
    build-csfq-link $n0 $n1 $rate $delay 1 1 $bufSize $bufThresh $pktSize $K
  }        


  set new 2

  for {set i 0} {$i < $nFlows} {incr i} {

    # build tcp source
    if { $type == "drr" } {

      set new [expr $new + 1]
      set n($new) [$ns node]
      build-drr-link $n($new) $n0 $rate $delay $bufSize $pktSize
      build-tcp $tcpType $n($new) $n1 $pktSize 0 $i [expr $startTime + $i*0.001]
    
    } else {
      build-tcp $tcpType $n0 $n1 $pktSize 0 $i [expr $startTime + $i*0.001]
     
    }
  }
  
  if { $type == "csfq" } {
    # init flows: flowid, weight_, k_ (usec)
    for {set i 0} {$i < $nFlows} {incr i} {
      set-csfq-queue $n0 $n1 $i 1 $kf
    }
  }
}



# build topology
proc build-topology { exp type nFlows delay K kf bufSize bufThresh pktSize startTime } {


  if { $exp == "alludp" } {
    build-topology-alludp $type $nFlows $delay $K $kf $bufSize $bufThresh $pktSize $startTime
  } elseif { $exp == "alltcp" } {
    build-topology-alltcp $type $nFlows $delay $K $kf $bufSize $bufThresh $pktSize $startTime
  } elseif { $exp == "oneudp" } {
    build-topology-oneudp $type $nFlows $delay $K $kf $bufSize $bufThresh $pktSize $startTime
  } elseif { $exp == "onetcp" } {
    build-topology-onetcp $type $nFlows $delay $K $kf $bufSize $bufThresh $pktSize $startTime
  }
}

# read command line arguments
for {set i 0} {$i < $argc} {incr i} {
        set opt [lindex $argv $i]
        if {$opt == "-type"} {
                set type [lindex $argv [incr i]]
        } elseif {$opt == "-exp"} {
                set exp [lindex $argv [incr i]]
        } elseif {$opt == "-n"} {
                set nFlows [lindex $argv [incr i]]
        } elseif {$opt == "-K"} {
                set K [lindex $argv [incr i]]
	} elseif {$opt == "-kf"} {
                set kf [lindex $argv [incr i]]
	} elseif {$opt == "-buf"} {
                set bufSize [lindex $argv [incr i]]
	} elseif {$opt == "-thresh"} {
                set bufThresh [lindex $argv [incr i]]
        } elseif {$opt == "-delay"} {
                set delay [lindex $argv [incr i]]
        }
}


#puts $type
#puts $nFlows 
#puts $delay
#puts $K
#puts $kf
#puts $bufSize
#puts $bufThresh
#puts $startTime
#puts "========"
# last two parameters are: packet size in bytes and 
# all times, excepting K and kf, are in ms and all sizes in bytes
# exp can be "onetcp", "alludp", "alltcp"
build-topology $exp $type $nFlows $delay $K $kf $bufSize $bufThresh $pktSize $startTime

$ns at $finishTime "finish"

proc finish {} {
        global ns f
        $ns flush-trace
        close $f
        exit 0
}
 
$ns run
