set ns [new Simulator]

# 
Queue/CSFQ set id_ 0
# in usec
Queue/CSFQ set kLink_ 200000
# 0 or 1
Queue/CSFQ set edge_  1
# in bits
Queue/CSFQ set qsize_ 100000
# in bits
Queue/CSFQ set qsizeThresh_ 70000
# in bps
Queue/CSFQ set rate_ 10000

#  (s0, s1) ) n_0
#                \0
#                 n2 --- n3
#                /1
#         (s2) n_1
 
# in usec
set kLink 100000
# in usec
set kRate 100000
# queue size (bits)
set qsize 512000
# queue threshold (bits)
set qsizeThresh 256000
set pktSize  1000
set  startTime 0
set tcpType  TCP

source ../my_sources.tcl

set n0 [$ns node]
set n1 [$ns node]
set n2 [$ns node]
set n3 [$ns node]

set f [open out.tr w]
$ns trace-all $f

set r1 1e+07
$ns duplex-link $n0 $n2 $r1 1ms CSFQ
$ns duplex-link $n1 $n2 $r1 1ms CSFQ
$ns duplex-link $n2 $n3 $r1 1ms CSFQ

build-tcp $tcpType $n0 $n3 $pktSize 0 0  $startTime 
build-tcp $tcpType $n0 $n3 $pktSize 0 1  [expr $startTime + 0.2]
build-tcp $tcpType $n1 $n3 $pktSize 0 2  [expr $startTime + 0.1]

Simulator instproc get-link { node1 node2 } {
    $self instvar link_
    set id1 [$node1 id]
    set id2 [$node2 id]
    return $link_($id1:$id2)
}

#Alternate way for setting parameters for the DRR queue
set l [$ns get-link $n0 $n2]
set q [$l queue]

# init flows: flowid, weight_, k_ (usec)
# init flows: flowid, weight_, k_ (usec)
$q init-flow 0 1 $kRate
$q init-flow 1 1 $kRate
# init link related parameters: 
# edge_ (0 or 1), 
# kLink_ (usec), 
# qsize_ (bits), 
# qsizeThresh_ (bits), 
# rate_ (bps)
$q set id_ 0
$q init-link 1 $kLink $qsize $qsizeThresh $r1

set l [$ns get-link $n1 $n2]
set q [$l queue]
$q init-flow 2 1 $kRate
$q set id_ 1
$q init-link 1 $kLink $qsize $qsizeThresh $r1


set l [$ns get-link $n2 $n3]
set q [$l queue]
$q set id_ 2
$q init-link 0 $kLink $qsize $qsizeThresh $r1

$ns at 10.0 "finish"

proc finish {} {
        global ns f
        $ns flush-trace
        close $f
        exit 0
}
 
$ns run













