set ns [new Simulator]


#                 n3      n6            n_3*(k-2)  
#                 |       |              |          
#  n0 ---- n1 --- n4 ---- n7 --- ...--- n_3*k-1 --- n_3*k
#          |      |       |                         
#          n2    n5      n8                 

#set f [open out.tr w]
#$ns trace-all $f

# 
Queue/CSFQ set id_ 0
# in usec
Queue/CSFQ set kLink_ 50000
# 0 or 1
Queue/CSFQ set edge_  1
# queue size (bits)
Queue/CSFQ set qsize_ 400000
# queue threshold (bits)
Queue/CSFQ set qsizeThresh_ 80000
# in bps
Queue/CSFQ set rate_ 10000

set pktSize    1000
set startTime  0.
set finishTime 10.
set delay      1.
set K          100
set kf         100
set rate       1e+07
set tcpType    TCP
set nFlows     11
set crtId      10

source ../my_sources.tcl
source ../my_links.tcl

# construct topology
proc build-topology-tcp {type num delay K kf bufSize bufThresh numFlows pktSize startTime } {
  global ns
  global crtId
  global rate
  global tcpType
  global finishTime

  set rate1 [expr $rate*2]

  for {set i 0} {$i < $num} {incr i} {
     
    set up [expr $i*3]
    set center [expr $i*3 + 1]
    set down   [expr $i*3 + 2]
    set n($up) [$ns node]
    set n($center) [$ns node]
    set n($down) [$ns node]

    if { $up == 0 } {
      build-link $type $n($up) $n($center) $rate1 $delay 1 0 $bufSize $bufThresh $pktSize $K 
    } else {
      build-link $type $n($up) $n($center) $rate1 $delay 1 0 $bufSize $bufThresh $pktSize $K 
    }
    build-link $type $n($center) $n($down) $rate1 $delay 0 1 $bufSize $bufThresh $pktSize $K 

    if { $i > 0 } {  
	
       set prev [expr $i*3 - 2]
       build-link $type $n($prev) $n($center) $rate $delay 0 0 $bufSize $bufThresh $pktSize $K 
       set pktInt [expr ($numFlows*$pktSize*8)/$rate1]
       set pd [expr $up - 1]       

       for {set j 1} {$j < $numFlows} {incr j} {

         if { $type == "csfq" } {

           set crtId [expr $crtId + 1]
           build-cbr $n($pd) $n($up) $pktSize $pktInt 1 $crtId $startTime
           set pc [expr $pd - 1]
           # init flow: flowid, weight_, k_ (usec)
           set-csfq-queue $n($pd) $n($pc) $crtId 1 $kf

         } else {
           
           set lidx [expr $j + $i*$numFlows];
           set n($lidx) [$ns node]
           build-link "fifo" $n($lidx) $n($pd) $rate 0 0 0 $bufSize $bufThresh $pktSize $K 
           set crtId [expr $crtId + 1]
           build-cbr $n($lidx) $n($up) $pktSize $pktInt 1 $crtId $startTime
	 }

       }
    }
  }     
        
    build-tcp $tcpType $n(0) $n($down) $pktSize 0 1  [expr $startTime + 0.0]
  if { $type == "csfq" } {
    set-csfq-queue $n(0) $n(1) 1 1 $kf
  }
  
  # log the traffic on link (n_3*k-1, n_3*k)
  set f [open link.tr w]
  set prev  [expr $down - 1]
  $ns trace-queue $n($prev) $n($down) $f
  $ns at $finishTime "close $f"
}

# construct topology
proc build-topology-udp {type num delay K kf bufSize bufThresh numFlows pktSize startTime } {
  global ns
  global crtId
  global rate
  global tcpType
  global finishTime

  set rate1 [expr $rate*2]

  for {set i 0} {$i < $num} {incr i} {
     
    set up [expr $i*3]
    set center [expr $i*3 + 1]
    set down   [expr $i*3 + 2]
    set n($up) [$ns node]
    set n($center) [$ns node]
    set n($down) [$ns node]

    if { $up == 0 } {
      build-link $type $n($up) $n($center) $rate1 $delay 1 0 $bufSize $bufThresh $pktSize $K 
    } else {
      build-link $type $n($up) $n($center) $rate1 $delay 1 0 $bufSize $bufThresh $pktSize $K 
    }
    build-link $type $n($center) $n($down) $rate1 $delay 0 1 $bufSize $bufThresh $pktSize $K 

    if { $i > 0 } {  
	
       set prev [expr $i*3 - 2]
       build-link $type $n($prev) $n($center) $rate $delay 0 0 $bufSize $bufThresh $pktSize $K 
       set pktInt [expr ($numFlows*$pktSize*8)/$rate1]
       set pd [expr $up - 1]       

       for {set j 1} {$j < $numFlows} {incr j} {

         if { $type == "csfq" } {

           set crtId [expr $crtId + 1]
           build-cbr $n($pd) $n($up) $pktSize $pktInt 1 $crtId $startTime
           set pc [expr $pd - 1]
           # init flow: flowid, weight_, k_ (usec)
           set-csfq-queue $n($pd) $n($pc) $crtId 1 $kf

         } else {
           
           set lidx [expr $j + $i*$numFlows];
           set n($lidx) [$ns node]
           build-link "fifo" $n($lidx) $n($pd) $rate 0 0 0 $bufSize $bufThresh $pktSize $K 
           set crtId [expr $crtId + 1]
           build-cbr $n($lidx) $n($up) $pktSize $pktInt 1 $crtId $startTime
	 }

       }
    }
  }     
        
  set pktInt [expr ($numFlows*$pktSize*8)/$rate]
  build-cbr $n(0) $n($down) $pktSize $pktInt 1 1 $startTime
  if { $type == "csfq" } {
    set-csfq-queue $n(0) $n(1) 1 1 $kf
  }

  # log the traffic on link (n_3*k-1, n_3*k)
  set f [open link.tr w]
  set prev  [expr $down - 1]
  $ns trace-queue $n($prev) $n($down) $f
  $ns at $finishTime "close $f"
}


# build topology
proc build-topology { exp type nLinks delay K kf bufSize bufThresh nFlows pktSize startTime } {

  if { $exp == "tcp" } {
    build-topology-tcp $type $nLinks $delay $K $kf $bufSize $bufThresh $nFlows $pktSize $startTime
  } elseif { $exp == "udp" } {
    build-topology-udp $type $nLinks $delay $K $kf $bufSize $bufThresh $nFlows $pktSize $startTime
  } 
}


# read command line arguments
for {set i 0} {$i < $argc} {incr i} {
        set opt1 [lindex $argv $i]
        if {$opt1 == "-type"} {
                set type [lindex $argv [incr i]]
        } elseif {$opt1 == "-exp"} {
                set exp [lindex $argv [incr i]]
        } elseif {$opt1 == "-n"} {
                set nLinks [lindex $argv [incr i]]
        } elseif {$opt1 == "-K"} {
                set K [lindex $argv [incr i]]
	} elseif {$opt1 == "-kf"} {
                set kf [lindex $argv [incr i]]
	} elseif {$opt1 == "-buf"} {
                set bufSize [lindex $argv [incr i]]
	} elseif {$opt1 == "-thresh"} {
                set bufThresh [lindex $argv [incr i]]
        } elseif {$opt1 == "-delay"} {
                set delay [lindex $argv [incr i]]
        }
}


#puts $type
#puts $nLinks
#puts $nFlows
#puts $delay
#puts $K
#puts $kf
#puts $bufSize
#puts $bufThresh
#puts $startTime
#puts "========"
# last two parameters are: packet size in bytes and 
# all times, excepting K and kf, are in ms and all sizes in bytes
# exp can be "tcp" or "udp"
build-topology $exp $type $nLinks $delay $K $kf $bufSize $bufThresh $nFlows $pktSize $startTime

$ns at $finishTime "finish"

proc finish {} {
        global ns f
        $ns flush-trace
#       close $f
        exit 0
}
 
$ns run













