#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <stdlib.h>

#include "util.h"

#define MAX_INT    0x7FFFFFFF


#define MAX_RAND_VEC 10000
int RandVec[MAX_RAND_VEC];

/* Initialize and array and pass it in to initstate. */
static long state1[32] = {
  3,
  0x9a319039, 0x32d9c024, 0x9b663182, 0x5da1f342,
  0x7449e56b, 0xbeb1dbb0, 0xab5c5918, 0x946554fd,
  0x8c2e680f, 0xeb3d799f, 0xb11ee0b7, 0x2d436b86,
  0xda672e2a, 0x1588ca88, 0xe369735d, 0x904f35f7,
  0xd7158fd6, 0x6fa6f051, 0x616e6b96, 0xac94efdc,
  0xde3b81e0, 0xdf0a6fb5, 0xf103bc02, 0x48f340fb,
  0x36413f93, 0xc622c298, 0xf5a42ab8, 0x8a88d77b,
  0xf5ad9d0e, 0x8999220b, 0x27fb47b9
};


void panic(char *s)
{
  printf("PANIC: %s\n", s);
  exit (-1);
}
 
void initRand(unsigned seed)
{
  int n;
 
  n = 128;
  initstate(seed, (char *) state1, n);
  setstate((char *)state1);
}
 

void initRandVec()
{
  int i;

  for (i = 0; i < MAX_RAND_VEC; i++) 
    RandVec[i] = random();
}


int getRandVec()
{
  static int i = 0;
  int res = RandVec[i];

  if (++i == MAX_RAND_VEC)
    i = 0;
  
  return res;
}


float funifRand(float a, float b)
{
  int c;
  float f =  (b - a)*((float)(c = random()))/((float)MAX_INT);
 
  return a + f;
}   

float funifVecRand(float a, float b)
{
  int c;
  float f =  (b - a)*((float)(c = getRandVec()))/((float)MAX_INT);
 
  return a + f;
}   


float fPareto(float mean)
{
  float a;

  if (mean <= 1.0)
    panic("fPareto: mean should be larger than 1.0.\n");

  a = mean/(mean - 1);

  return 1.0/pow(funifRand(0., 1.), 1.0/a);
}   


float fVecPareto(float mean)
{
  float a;

  if (mean <= 1.0)
    panic("fPareto: mean should be larger than 1.0.\n");

  a = mean/(mean - 1);

  return 1.0/pow(funifVecRand(0., 1.), 1.0/a);
}   


float fExp(float mean)
{
  float u;

  while ((u = funifRand(0., 1.)) == 0.0);

  return -mean * log(u);
}   


float fVecExp(float mean)
{
  float u;

  while ((u = funifVecRand(0., 1.)) == 0.0);

  return -mean * log(u);
}   

