# Infobot user extension stubs 
# Kevin A. Lenzo

# put your routines in here.

do 'src/nickometer.pl'; # Adam Spier's "lame nick-o-meter" code

sub myRoutines {
    # called after it decides if it's been addressed.
    # you have access tothe global variables here, 
    # which is bad, but anyway.

    # you can return 'NOREPLY' if you want to stop
    # processing past this point but don't want 
    # an answer. if you don't return NOREPLY, it
    # will let all the rest of the default processing
    # go to it. think of it as 'catching' the event.

    # $addressed is whether the infobot has been 
    #			named or, if a private or standalone
    #			context, addressed is always 'true'

    # $msgType can be 'public', 'private', maybe 'dcc_chat'

    # $who is the sender of the message

    # $message is the current state of the input, after
    #		  the addressing stuff stripped off the name

    # $origMessage is the text of the original message before
    #			  any normalization or processing

    # you have access to all the routines in urlIrc.pl too,
    # of course.

    # example:

    if ($addressed) {
	# only if the infobot is addressed
	if ($message =~ /how (the hell )?are (ya|you)( doin\'?g?)?\?*$/) {
	    if ($msgType eq 'public') {
		&say($howAreYa[rand($#howAreYa)].", $who");
	    } else {
		&msg($who, $howAreYa[rand($#howAreYa)].", $who");
	    }
	    return 'NOREPLY';
	}
    } else {
	# we haven't been addressed, but we are still listening
    }


    if ($message =~ /^\s*(?:lame|nick)-?o-?meter(?: for)? (\S+)/i) {
	my $term = $1;
	if (lc($term) eq 'me') {
	    $term = $who;
	}

	$term =~ s/\?+\s*//;

	my $percentage = &nickometer($term);

	if ($percentage =~ /NaN/) {
	    $percentage = "off the scale";
	} else {
	    $percentage = sprintf("%0.4f", $percentage);
	    $percentage =~ s/\.?0+$//;
	    $percentage .= '%';
	}
	
	if ($msgType eq 'public') {
	    &say("'$term' is $percentage lame, $who");
	} else {
	    &msg($who, "the 'lame nick-o-meter' reading for $term is $percentage, $who");
	}

	return 'NOREPLY';
    }

    if ($message =~ /^foldoc (.*)/i) {
	my ($terms) = $1;
	$terms =~ s/\?\W*$//;
	
	my $key= $terms;
	$key =~ s/\s+$//;
	$key =~ s/^\s+//;
	$key =~ s/\W+/+/g;

	my $reply = "$terms may be sought in at foldoc at http://wombat.doc.ic.ac.uk/foldoc/foldoc.cgi?query=$key";

	if ($msgType eq 'public') {
	    &say($reply);
	} else {
	    &msg($who, $reply);
	}
	return 'NOREPLY';
    }

    if ($message =~ /^(?:quote|stock price)(?: of| for)? ([A-Z]{1,6})\?*$/) {
	my $reply = "stock quotes for $1 may be sought at http://quote.yahoo.com/q?s=$1\&d=v1";

	if ($msgType eq 'public') {
	    &say($reply);
	} else {
	    &msg($who, $reply);
	}
	return 'NOREPLY';
    }


    if ($message =~ /^rot13\s+(.*)/i) {
	# rot13 it
	my $reply = $1;
	$reply =~ y/A-Za-z/N-ZA-Mn-za-m/;
	if ($msgType eq 'public') {
	    &say($reply);
	} else {
	    &msg($who, $reply);
	}
	return 'NOREPLY';
    }


    return '';	# do nothing and let the other routines have a go
}

@howAreYa = ("just great", "peachy", "mas o menos", 
	 "you know how it is", "eh, ok", "pretty good. how about you");
1;
