
# infobot :: Kevin Lenzo   (c) 1997

sub setup {
    my (%dbs) = @_;

    srand();

    $setup_time = scalar(localtime());
    $setup_time =~ s/\n//g;

    $startTime = time();

    &openDBM(%dbs);

    $qCount = &get("is", "the qCount");
    $qEpochTime = &get("is", "the qEpochTime");

    # things to say when people thank me
    @welcomes = ('no problem', 'my pleasure', 'sure thing',
		 'no worries', 'de nada', 'de rien', 'bitte', 'pas de quoi');

    # when i'm cofused and I have to reply
    @confused = ("huh?", 
		 "what?", 
		 "sorry...", 
		 "i\'m not following you...",
		 "excuse me?");

    # when i recognize a query but can't answer it
    @dunno = ('i don\'t know', 
	      'wish i knew',
	      'i haven\'t a clue',
	      'no idea',
	      'bugger all, i dunno');

    # people to ignore
    @permignore = "";
    foreach $x (@permignore) {
	$ignoreList{$x}++;
    }

    # ways to say hello
    @hello = ('hello', 
	      'hi',
	      'hey',
	      'niihau',
	      'bonjour',
	      'hola',
	      'salut',
	      'que tal',
	      'what\'s up');

    @specialPeople = ("oznoid", "jadin", "racer-x");

    $param{'maxKeySize'}  ||= 30; # maximum LHS length
    $param{'maxDataSize'} ||= 200; # maximum total length

    if (!defined(@verb)) {
	@verb = split(" ", "is are");
	#  am was were does has can wants needs feels
	#  handle s-v agreement for non-being verbs later
    }

    if (!defined(@qWord)) {
	@qWord = split(" ", "what where who"); # why how when
    }

    # do this ONCE per startup to amortize.  Still too much mem.
    #&getAllKeys;
    $isCount = &getDBMKeys('is'); 
    $areCount = &getDBMKeys('are');
    $factoidCount = $isCount + $areCount;

    &status("setup: $factoidCount factoids; $isCount IS; $areCount ARE");
}

1;
