
#include <windows.h>
#include <stdio.h>
#include <initguid.h>
#include <spchwrap.h>

#include <jni.h>
#include "jspeech.h"


#define MAXVOICE  100
//this variable will contain the different voice modes
static GUID agVoice[MAXVOICE];


CVoiceText *SpeakObject;
void textSpeech(char intext[])
{
	WCHAR theText[255];
	int thesize,i;
	thesize = strlen(intext);

	if (thesize > 254) exit(0);

	for (i=0; i < thesize; i++)
		theText[i] = (short)intext[i];
	theText[i] = (short)'\0';

	SpeakObject->Speak(theText);
	printf("Now I have returned\n");
}

int openSpeech()
{

	CoInitialize(0);					//must call this to initilize COM
	SpeakObject = new CVoiceText;	    //create a voice object

	if(!SpeakObject)					
	{
		printf("unable to create speak object.\n");
		exit(-1);
	}

	if(SpeakObject->Init(L"speak.exe")) //initialize object
	{
		printf("unable to initialize speak object.\n");
		exit(-1);
	}

	// Find the different voice modes supported
    PITTSENUM   pITTSEnum = NULL;
    CoCreateInstance(CLSID_TTSEnumerator, NULL, CLSCTX_ALL, IID_ITTSEnum,
                                                   (void**)&pITTSEnum);
    DWORD i;
    TTSMODEINFO inf; //structure containing the settings for each mode
    DWORD dwTimes;

	//for each voice mode supported add it to the list
    for (i = 0; ; i++)
	{
        if (pITTSEnum->Next(1, &inf, &dwTimes))
            break;
        // add the name to the array of voice modes supported
        agVoice[i] = inf.gModeID;
    }

	//debug statement
	// printf("The number of different configurations are: %i\n", i);

	//release the structure containing the settings for each mode
	//just keep the list of modes supported
    pITTSEnum->Release();


	textSpeech("Initialized.");
	//printf("Hit enter when done...\n");
	//getchar();
	//CoUninitialize();	

	// return the number of different voice configurations... //
	return i;
}

closeSpeech()
{
	CoUninitialize();
	return 1;
}


void main()
{
	printf("Hello world!\n");
	//getchar();
	//closeSpeech();
}

JNIEXPORT jint JNICALL Java_jspeech_openSpeech
(JNIEnv *jnienv, jobject jobj) {
	return openSpeech();
	//return 1;

}

JNIEXPORT jint JNICALL Java_jspeech_closeSpeech
(JNIEnv *jnienv, jobject jobj) {
	closeSpeech();
	return 1;
}


JNIEXPORT jint JNICALL Java_jspeech_textSpeech
	(JNIEnv *jnienv, jobject job1, jstring thetext) {

	char textcopy[255];
	jboolean tempbool = TRUE;
	const char *str;
	str = (* jnienv).GetStringUTFChars(thetext, &(tempbool));

	if (strlen(str) < 254) {
		strcpy(textcopy, str);
		textSpeech(textcopy);
	}
	(* jnienv).ReleaseStringUTFChars(thetext,str);

	return 1;
}

JNIEXPORT jint JNICALL Java_jspeech_voiceSpeech
(JNIEnv *jnienv, jobject jobj, jint voice) {

	DWORD MyMode = voice;
	SpeakObject->TTSModeSet(agVoice[MyMode]);

	return 1;
}

