function [x1 weight] = GazeConcurrenceMeanShift(x, data_p, data_v, h)

%%
% Gaze Concurrence Estimation
% Implementation of Equation (6) in 
% Park, Jain, and Sheikh, "3D Social Saliency from Head-mounted Cameras"
% (NIPS 2012)
%
% INPUT
% x: initialized 3D point
% data_p: 3 by N matrix where each column corresponds to the center of
% primary gaze direction
% data_v: 3 by N matrix where each column corresponds to the direction of
% primary gaze direction
% h: gaze cone bandwidth
% OUTPUT
% x1: next 3D point
% weight: contribution of each primary gaze rays

%%
nominator = 0;
denominator = 0;

for i = 1 : size(data_p,2)
    p = data_p(:,i);
    v = data_v(:,i);
    
    % Measure distance
    dist = DistanceBetweenRayAndPoint(p,v,x);
  
    % Compute weight
    w = exp(-norm(dist)^2/h^2/2)/(h^3*(v'*(x-p))^2);
    % Compute x_tilde
    x_hat = p+v'*(x-p)*v;
    x_tilde = x_hat + (norm(x-x_hat)^2/(v'*(x-p))) * v;
    nominator = nominator + w * x_tilde;
    denominator = denominator + w;
    weight(i) = w;
end
x1 = nominator/denominator;
weight = weight / denominator;
