function dist = DistanceBetweenRayAndPoint(p,v,x)
%%
% Gaze Concurrence Estimation
% Implementation of Equation (4) in 
% Park, Jain, and Sheikh, "3D Social Saliency from Head-mounted Cameras"
% (NIPS 2012)
%
% INPUT
% p: the center of primary gaze ray (3x1)
% v: the direction of primary gaze ray (3x1)
% x: the 3D location to be evaluated
% OUTPUT
% dist: distance between the ray and point

if v'*(x-p) < 0
    dist = 1e+6;
else
    x_hat = p + (v'*(x-p))*v;
    dist = (x-x_hat)/(v'*(x-p));
end
