clc
format('compact')
echo on

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% MATLAB = MATrix LABoratory         %%
%%   (Almost) everything is a matrix  %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Creating a matrix by hand %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            [1 2 3; 4 5 6; 7 8 9]   %% 1st way to create a matrix

            [1,2,3; 4,5,6; 7,8,9]   %% 2nd way to make the same matrix
            
            [[1 2; 4 5; 7 8] [3; 6; 9]] %% Horizontal concatenation of two matrices
            
            [[1 2 3; 4 5 6]; [7 8 9]] %% Vertical concatenation of two matrices
pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% What is a scalar?        %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            [5.7]
            5.7
            3e-10

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Also a 1x1 Matrix of course! %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Creating a matrix using functions %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            
            zeros(5,4)  %% all zero matrix
            
            ones(3,7)  %% all ones matrix
            
            %% What else is there to know about the "ones" function?
pause

            help ones  %% The help system is quite good and VERY useful!!!
          
pause
clc

            rand(2,9)  %% uniform random
            
            randn(3,3) %% N(0,1) random
            
            eye(7)     %% The Identity matrix

            %% How might you create random data ~ N(3, 4)?? 
            
pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%
%% The Colon Notation %%
%%%%%%%%%%%%%%%%%%%%%%%%

            1:10     %% start:finish
            
            0:.05:1  %% start:increment:finish
            
            10:-1:1  %% can go down also

pause
clc


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Assigning Matrices to Variables   %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            A = [1 2; 3 4; 5 6]
            
            B = rand(4,8)
            
            C = 3.14
pause
clc
            whos     %% Let's see what variables exist is memory

pause
            
            A     %% Those variables can now be used
            
            B
            
            C
pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Logical (Another type besides double)  %%          
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
           D = logical([1 0 0; 0 1 1; 0 0 0])    %% True (1) or false (0)

           whos
           
           pause

pause
clc

%%%%%%%%%%%%%%%
%%  Strings  %%          
%%%%%%%%%%%%%%%

           message = 'Hello World'
           
           message(1) = 'J'
           
           whos message

pause
clc



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Indexing a matrix  (3 ways) %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%
%%  Matrix indexing %%
%%%%%%%%%%%%%%%%%%%%%%

           B
           
           B(1,1)    %% The entry from the first row, first column
           
           %% What will B(3,2) return?
pause
           B(3,2)
           
           %% What will B(0,0) return?    
pause
           %%  An ERROR!! :-(  A key difference from other languages!
%%% ??? Subscript indices must either be real positive integers or logicals.
           
pause
clc
           B
           
           B([1 2],[1 3 4])  %% 2x3 sub-matrix
           
           B(1:3, 2:6)

pause
clc
           B
   
           B(:,1)    %% ":" indexes whole column or row
           
           B(1,:)
           
           B(end,:)  %% end is equivalent to the largest row or vector  
           
pause
clc

           B(1,:) = .5  %% Can assign directly into whatever is indexed
           
           B(end,end) = .7 

pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Linear (array) indexing  %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            B
            
            B(1)

            B(2)
            
            B(6)
            
            %% What will B(:) do?

pause

            B(:)
pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%
%%  Logical indexing  %%
%%%%%%%%%%%%%%%%%%%%%%%%

            C = rand(3,3)
            
            C(logical([0 0 0; 0 1 1; 1 0 0]))
            
            C([1 2 3; 4 5 6; 7 8 9] > [1 4 7; 2 5 8; 3 6 9])

            C(logical([0 0 0; 0 1 1; 1 0 0])) = .1234
           
            C(logical([1 1 0; 1 0 0; 0 0 0])) = [ .1 .2 .3];
pause
clc

            %% Conversion from logical to linear
            find(logical([0 0 0; 0 1 1; 1 0 0]))

pause
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  You should now know how to:                   %% 
%%      Create arrays by hand                     %%
%%      Use Special functions for creating arrays %%
%%      Use the colon to make vectors             %%
%%      Index matrices in 3 ways                  %%
%%          - Matrix                              %%
%%          - Linear                              %%
%%          - Logical                             %%
%%      Assign to indexed portions of arrays      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%    QUESTION BREAK     %%%%%%%%%%%%%%%

pause