function efficiency()

   %% Understanding what happens under the hood of MATLAB can 
   %% help you avoid writing horribly slow code, especially
   %% when dealing with large datasets

    function[res] = fib_A(n)
        res(1) = 1;
        res(2) = 1;
        for i=3:n
            res(i) = res(i-1) + res(i-2);
        end
    end
        
       
    function[res] = fib_B(n)
        res = zeros(1,n); %% ONLY DIFFERENCE
        res(1) = 1;
        res(2) = 1;
        for i=3:n
            res(i) = res(i-1) + res(i-2);
        end
    end

    disp('Fibonacci calculation comparison');

    pause
    
    tic()
    disp('fib A');
    res = fib_A(50000);
    toc()

    tic()
    disp('fib B');
    res = fib_B(50000);
    toc()

    res(1:10)
    
    pause

    %% YIKES!!!
    %% Why????
    
    %% Each time you reallocate the size of an array, a new place 
    %% in memory may need to be found to fit that array.  
    
    %% Pre-allocation finds the right-sized place ONCE!!!  So
    %% Always preallocate when you are going to build LARGE arrays!

   
    function A(data)
        x = data(1,1);
    end
        
       
    function B(data)
        data(1,1) = 0;
    end

    %% Which of these functions takes longer to run??
    pause

    disp('Data passing comparison');
    
    data = rand(1000,1000);
    pause
    
    disp('A');
    tic()
    for t=1:100
        A(data)
    end
    toc()
    
    disp('B');
    tic()
    for t=1:100
        B(data)
    end
    toc()
    pause
    
    %% YIKES!!!
    %% Why????
    
    %% MATLAB is lazy pass by value.  It won't make a local copy
    %% of data passed to it UNLESS the data is modified.
    
    %% The solution can sometimes be to use global data 
    %% (help global)
    
end