function counting()
   echo counting on;

   %% We want to load some tab-delimited data
   data = load('breast-cancer.data');

   pause
   %% What if it had been comma-delimited??

   %data = textread('breast-cancer.data', 'delimiter', ',');
   
   pause
   
   %% We can also save data to disk (in binary format)
   
   save data data;   %% saves matrix "data" to file "data.mat"
   
   pause
   
   %% and reload that data
   load data;
   
   pause
   
   size(data)
   
   pause
   
   data
   
   %% Class is the 10th column of the data
   class = data(:,10);
   
   features = data(:,1:9);
   
   %% Plot a histogram of the first feature
   disp('Displaying histogram');
   hist(features(:,1));
  
   pause
   
   %% Histogram can also be used to count things...
   [counts, positions] = hist(features(:,1));
   
   counts
   
   %% How might we change these into probabilities? 
   pause
   
   probabilities = counts / sum(counts)
   
   pause
   
   %%What if we wanted to condition on other variables, like
   %%Class=2

   featuresClass2 = [];
   
   for (i=1:length(class))
      if (class(i)==2)
          featuresClass2 = [featuresClass2; features(i,:)];
      end
   end
   
   [counts, positions] = hist(featuresClass2(:,1));
   condProbability = counts/sum(counts)
   
   pause
   %% That was how a C, C++, Java, etc. programmer might be 
   %% inclined to condition...  in Matlab it makes bloated-looking 
   %% code that runs slowly.
   %%
   %% Instead we need to use Matrix operations and vectorize
   %% as much as possible!
   pause
   
   featuresClass2 = features(class==2, :);
   
   [counts, positions] = hist(featuresClass2(:,1));
   
   condProbability = counts/sum(counts)
   
   pause

   
   %% Structures may also be useful
   order = randperm(length(class)); %% Create a random order
   dataset.train_class = class(order(51:end));
   dataset.train_features = features(order(51:end), :);
   dataset.test_class = class(order(1:50));
   dataset.test_features= features(order(1:50), :);
   
   dataset
   
   pause
   
   %% Another useful way of arranging data is cells
   %% Unlike arrays, cell contents can be of different types
   C{1} = [1 2 3];
   C{2} = 'hello world';
   C{3} = 0.1234
      
   C
end