function regression_example() 

   format('loose');  %% show extra lines in command window

   beta = [1 -5 6]'  %%  set the true parameters
    
   N_train = 50;   %% number of examples to train with
   N_test = 50;   %% number of examples to test with

   %% Generate some plotting points
   points = (0:.01:1)';
   points = [points.^0 points.^1 points.^2];

   hold off
   
   %% Plot the true line
   disp('Plotting true function');  %% output text
   plot(points(:,2), points*beta, 'g');

   hold on        %% Keep the current plot open

   legend('true function');   %% Add a legend to the plot
   pause
   

   
   %% Generate N training examples
   x = rand(N_train,1);
   x_train = [x.^0 x.^1 x.^2];  %% polynomial degrees of x
   
   %% Generate N testing examples
   x = rand(N_test  ,1);
   x_test = [x.^0 x.^1 x.^2];
   
   %% Generate the training responses
   y_train = noisy_function(beta, x_train, 1);
   
   %% Generate the testing responses
   y_test = noisy_function(beta, x_test, 1);
   
   %% Plot the training data 
   disp('Plotting training data');  
   plot(x_train(:,2), y_train, '.');
   legend('true function', 'training data');
         
   pause
   
   %% How do we learn ML beta from x_train, y_train?
   %% beta = (X * X')^-1 * X' * Y
   disp('Our estimates');
   beta_hat = inv(x_train' * x_train) * x_train' * y_train
  
   pause
  
   %% MATLAB also has built-in linear regression functions
   disp('Regress results')  %% Write some text to output
   regress(y_train, x_train)
   
   pause
   
   %% Plot the prediction function
   disp('Plotting prediction function');  
   plot(points(:,2), points*beta_hat);
   legend('true function', 'training data', 'prediction line');
   
   pause
   
   %% Plot the testing data (in Green)
   disp('Plotting testing data');  
   plot(x_test(:,2), y_test, 'r.');
   legend('true function', 'training data', 'prediction line', 'testing data');   
   
   pause
   
   %% Calculate predictions for test data
   y_predict = x_test * beta_hat;
   
   %% Compute Mean-Squared-Error of test predictions
   disp('test MSE');
   MSE_test = mean([y_predict-y_test].^2)

   %% Calculate predictions for training data
   y_predict = x_train * beta_hat;
   
   %% Compute Mean-Squared-Error of train predictions
   disp('train MSE');
   MSE_train = mean([y_predict-y_train].^2)
   
   
   
   hold off
end