// test-memalloc.c : unit test for the memalloc dynamic memory allocator
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Foobar; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

#include <libstd.h>
#include <errcodes.h>
#include <libLPC2xxx.h>

#if !defined(TARGET_OSX) && !defined(TARGET_POSIX)
#include <LED_indicators.h>
#include <UART_raw_port.h>
static UART_raw_port console_port;
#endif

/****************************************************************/
// The unallocated memory pool.
#define POOLSIZE 128
static unsigned char pool[ POOLSIZE ];

static int
init_tests( void )
{
  return init_memalloc( pool, POOLSIZE );
}

/****************************************************************/
static int memtest1(void)
{
  void *p[5];
  int i;
  int errors = 0;
  int iterations;
  
  for ( iterations = 0; iterations < 2; iterations++ ) {
    format( NULL, "memtest1 iteration ~d~%", iterations );
    for ( i = 0; i < 5; i++ ) {
      p[i] = memalloc( 4 );
      if ( p[i] == NULL) errors++;
      else memset( p[i], 0xff, 4 );
      format( NULL, "allocated memory at ~x~%", p[i] );
    }

    memfree( p[0] );
    memfree( p[2] );
    memfree( p[1] );
    memfree( p[4] );
    memfree( p[3] );
  }
  return errors;
}

/****************************************************************/
// Build a linked list of blocks of different sizes, then try
// freeing them all.

static int memtest2(void)
{
  void **head, **tail;
  int errors = 0;
  int size = 4;
  int blocks = 1;

  head = (void **) memalloc ( 4 );
  if ( head == NULL ) return 1;
  *head = NULL;
  tail = head;
  format ( NULL, "memtest2 allocated list head at ~x~%", head );

  for (;;) {
    void **newblock = ( void **) memalloc( size );
    if ( newblock == NULL ) {
      format( NULL, "ran out of memory at size ~d, ~d blocks allocated~%", size, blocks );
      break;
    }
    format( NULL, "allocated block at ~x~%", newblock );
    // insert into list
    *newblock = NULL;
    *tail = newblock;
    tail = newblock;
    blocks++;
    size++;
  }

  // walk the list freeing blocks
  while ( head != NULL ) {
    void **next = (void **) *head;
    format( NULL, "freeing block at ~x~%", head );
    memfree( head );
    head = next;
  }

  return errors;
}

/****************************************************************/
int run_tests(void)
{
  int errors = 0;

  format( NULL, "test-memalloc (revision " SVN_REVISION ") waking up.\n" );

  init_tests();
 
  errors += memtest1();
  errors += memtest2();
  errors += memtest1();

  format( NULL, "\ntest-memalloc finished with ~d errors\n", errors);
  return errors;
}

/****************************************************************/
/****************************************************************/
#if !defined(TARGET_OSX) && !defined(TARGET_POSIX)
int main (void)
{
  int i;
  UART_raw_port_init( &console_port, &UART0, UART0_DIVISOR, PORT_FLAGS_READ|PORT_FLAGS_WRITE|PORT_FLAGS_CRLF );
  current_output_port = (struct port_t *) &console_port;
  current_input_port  = (struct port_t *) &console_port;
  
  run_tests();

  while ( 1 ) {

#if CONFIG_CPU_LED_MASK
    for ( i = 0; i < 10000000; i++ ) ;
    CPU_LED_on();
    for ( i = 0; i < 10000000; i++ ) ;
    CPU_LED_off();
#endif
  }

}
#endif

/****************************************************************/
#if defined(TARGET_OSX) || defined(TARGET_POSIX)
int main (int argc, char **argv)
{
  return run_tests();
}
#endif
/****************************************************************/


