// config.h : library source code configuration file for the test programs
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Foobar; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

// Configuration of the specific hardware and software environment for
// compiling the entire body of code for a specific target.  This
// allows both the LPC2xxx library and application code to be
// customized.

// The overall order of inclusion in any given source file should be:
//   config.h		this file
//     LPC2103.h	the CPU hardware variant
//        lpc2xxx.h	the generic CPU definition
//   libstd.h		the hardware-independent support library
//   libLPC2xxx.h	the hardware interface support library

// Since this directory is for tests to the baseline software, this
// config file should contain a minimum of special definitions; i.e.,
// wherever possible it should use the default settings, except where
// they must necessarily be specialized by target.

/****************************************************************/ 
#ifndef __CONFIG_H_INCLUDED__
#define __CONFIG_H_INCLUDED__

/****************************************************************/
// A Mac OS X unix host.
#ifdef TARGET_OSX
#define LIBSTD_USE_SYSTEM_C_DEFINITIONS 1
#endif

/****************************************************************/
// A generic unix host.
#ifdef TARGET_POSIX
#define LIBSTD_USE_SYSTEM_C_DEFINITIONS 1
#endif

/****************************************************************/
// The Public Secrets Revision 6 controller, based around an Olimex
// LPC-H2138 header board.

#ifdef TARGET_PS6
#include <LPC2138.h>

// The PS6 has an array of six general purpose indicator LEDs.
#define CONFIG_LED_MASK   0xfc000000  // P1.26 through P1.31
#define CONFIG_LED_SHIFT  26
#define CONFIG_LED_GPIO   GPIO1

// The Olimex LPC2138 board has a green LED on P0.31
#define CONFIG_CPU_LED_MASK   (0x80000000)  
#define CONFIG_CPU_LED_GPIO   GPIO0

// This is required for full FAT16 read/write testing.
#define CONFIG_INCLUDE_MMC_WRITE_BLOCK 1

#endif

/****************************************************************/
// McBlare Revision 1 Controller, based around an Olimex LPC-H2103
// header board.
#ifdef TARGET_MBC
#include <LPC2103.h>

// The MBC has an array of six general purpose indicator LEDs.
#define CONFIG_LED_MASK 0x000000fc  // P0.2 through P0.7
#define CONFIG_LED_SHIFT 2
#define CONFIG_LED_GPIO GPIO0

// The Olimex LPC2103 board has a green LED on P0.26
#define CONFIG_CPU_LED_MASK  (0x04000000)  
#define CONFIG_CPU_LED_GPIO  GPIO0
#endif

/****************************************************************/
// The Olimex LPC-P2103 Prototyping board.  The board includes a
// female DB9 and MAX3232 driver connected to UART0.

#ifdef TARGET_OP03
#include <LPC2103.h>

// The Olimex LPC-P2103 board has a green LED on P0.26
#define CONFIG_CPU_LED_MASK  (0x04000000)  
#define CONFIG_CPU_LED_GPIO  GPIO0

// The Olimex LPC-P2103 board has a button on P0.15
#define CONFIG_BUTTON1_MASK  (0x00008000)  
#define CONFIG_BUTTON1_GPIO  GPIO0

#endif

/****************************************************************/
// The Olimex LPC-P2148 Prototyping board.  The board includes two
// female DB9 connectors and MAX3232 driver connected to UART0 and
// UART1.

#ifdef TARGET_OP48
#include <LPC2148.h>

// Unlike the other Olimex boards, this one has a 12MHz crystal
// for conveniently generating a USB clock.
#define FOSC              (12000000)       // crystal oscillator frequency
#define CLOCKMULT         (5)              // PLL multiplier rate; CCLK = FOSC * CLOCKMULT

// The board has a pair of active-low LEDS on P0.10 and P0.11.  These
// are defined as indicators, with no CPU LED, since they are each
// clearly associated with a switch.

#define CONFIG_LED_MASK 0x00000c00
#define CONFIG_LED_SHIFT 10
#define CONFIG_LED_GPIO GPIO0

// The board has a buttons on P0.15 and P0.16
#define CONFIG_BUTTON1_MASK  (0x00008000)  
#define CONFIG_BUTTON1_GPIO  GPIO0
#define CONFIG_BUTTON2_MASK  (0x00010000)  
#define CONFIG_BUTTON2_GPIO  GPIO0

// The board has a piezo buzzer connected across P0.12 and P0.13.
#define CONFIG_BUZZER1A_MASK  (0x00001000)
#define CONFIG_BUZZER1B_MASK  (0x00002000)
#define CONFIG_BUZZER1_GPIO   GPIO0

#endif

/****************************************************************/
// The Light-as-Air Rev 1 board.  The board has a connector for 
// an external MAX232 dongle connected to UART0.

#ifdef TARGET_LAA
#include <LPC2103.h>

// LED1 as the green CPU led on P0.12
#define CONFIG_CPU_LED_MASK  (0x00001000)  
#define CONFIG_CPU_LED_GPIO  GPIO0

// LED2 is the RED sole "indicator LED" on P0.13
#define CONFIG_LED_MASK 0x00002000  // P0.13
#define CONFIG_LED_SHIFT 13
#define CONFIG_LED_GPIO GPIO0

// The user switch is a button on P0.15
#define CONFIG_BUTTON1_MASK  (0x00008000)  
#define CONFIG_BUTTON1_GPIO  GPIO0

#endif

/****************************************************************/
// Here is where appears application-specific configuration settings
// for the libraries.

#define LIBSTD_FORMAT_SUPPORTS_BINARY 1
#define LIBSTD_FORMAT_SUPPORTS_FIXED  1

// Some kind of console is required for testing.  This sets up a basic
// default unbuffered serial port on UART0.
#define CONFIG_UART0_DEFAULT_INIT 1
#define CONSOLE_USES_UNBUFFERED_SERIAL 1
#define LIBSTD_STANDARD_PORTS_DEFAULT 1

#endif //  __CONFIG_H_INCLUDED__
/****************************************************************/
