// standard_ports.c : interface to stdio standard ports using libstd port abstraction
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
/****************************************************************/
// Standard ports using a simple port abstraction.  This just
// calls the user-supplied external putchar() and getchar().

#include <libstd.h>
#include <port.h>

static int peeked_char = -1;

static int std_port_read_char(struct port_t *p)
{
  int c;
  if (peeked_char != -1 ) {
    c = peeked_char;
    peeked_char = -1;
  } else c = getchar();
  return c;
}
static int std_port_peek_char(struct port_t *p)
{
  if (peeked_char == -1 ) peeked_char = getchar();
  return peeked_char;
}
static int std_port_write_char(struct port_t *p, int c)
{
  return putchar(c);
}
#if !defined(TARGET_OSX) && !defined(TARGET_POSIX)
static int std_port_char_ready(struct port_t *p)
{
  return char_ready_p();
}
#endif
const static struct port_class_t standard_console_port_class = {
  // use a C99 notation for selectively initializing structure elements
  .read_char  = std_port_read_char,
  .peek_char  = std_port_peek_char,

#if !defined(TARGET_OSX) && !defined(TARGET_POSIX)
  .char_ready = std_port_char_ready,
#endif

  .write_char = std_port_write_char,
};

struct port_t standard_output_port = {
  &standard_console_port_class,
  PORT_FLAGS_WRITE | PORT_FLAGS_INITIALIZED,   // flags
  -1
};

struct port_t standard_input_port = {
  &standard_console_port_class,
  PORT_FLAGS_READ | PORT_FLAGS_INITIALIZED,   // flags
  -1
};
