// null_port.c : definition for the port object equivalent of /dev/null
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// The "/dev/null" port.

#include <libstd.h>
#include <errcodes.h>
#include <port.h>

// Definition of the null port.
const static struct port_class_t null_port_class = {
  // use a C99 notation for selectively initializing structure elements
  .close = NULL   // all entries will be null
};

// Initialize a null port.
int 
null_port_init( null_port *p ) 
{
  generic_port_init( p, &null_port_class, PORT_FLAGS_READ | PORT_FLAGS_WRITE | PORT_FLAGS_INITIALIZED );
  return ERRNOERROR;
}

