// utility.c : miscellaneous support code
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#include <utility.h>

// The ARM7 is a little-endian chip, and the network byte order is
// big-endian.  These convert integers of various sizes to and from
// network byte order.

UINT32 htonl( UINT32 data)
{
  unsigned int value;
  unsigned char *dst = (unsigned char *) &value;
  unsigned char *src = (unsigned char *) &data;
  dst[0] = src[3];
  dst[1] = src[2];
  dst[2] = src[1];
  dst[3] = src[0];
  return value;
}

UINT32 ntohl( UINT32 data)
{
  return htonl( data );
}

UINT16 htons( UINT16 data)
{
  unsigned int value;
  unsigned char *dst = (unsigned char *) &value;
  unsigned char *src = (unsigned char *) &data;
  dst[0] = src[1];
  dst[1] = src[0];
  return value;
}

UINT16 ntohs( UINT16 data)
{
  return htons( data );
}

