// timing.h : utility routines to compute time intervals
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#ifndef __TIMING_H_INCLUDED__
#define __TIMING_H_INCLUDED__

// A free running counter maintained by the timer interrupt.
extern volatile unsigned int timerclock;  

typedef struct {
  unsigned elapsed;
  unsigned last_clock;
} elapsed_timer;

// Reset an elapsed timer to a zero count.  Time is measured in ticks
// of the timerclock variable.
extern int elapsed_timer_init( elapsed_timer *timer );

// Update the state of an elapsed timer and return the time elapsed
// since reset (in timerclock units).
extern unsigned elapsed_timer_update( elapsed_timer *timer );

// This is only actually included if CONFIG_INCLUDE_TIMERSLEEP is enabled.
extern void timersleep( unsigned int counts );

#endif // __TIMING_H_INCLUDED__
