// serial_console.h : the most basic polled console interface for UART0
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// A very basic interface for a single UART0 console.

#ifndef SERIAL_CONSOLE_H_INCLUDED
#define SERIAL_CONSOLE_H_INCLUDED

// These are true if a single-character input or output would not block.
extern int serial_input_ready(void);
extern int serial_output_ready(void);

// Get a character, blocking until ready.
extern unsigned char serial_getchar(void);

// Output a character or string, blocking if the transmitter is not ready.
extern void serial_putchar(unsigned char c);
extern void serial_puts(unsigned char *s);

#endif // SERIAL_CONSOLE_H_INCLUDED
