// serial_console.c : the most basic polled console interface for UART0
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// A very basic interface for a single UART0 console.

#include <libLPC2xxx.h>
#include <serial_console.h>

// Minimal low-level console I/O functions.  These use no interrupts
// or buffers and generally can block if appropriate.

int serial_input_ready(void)
{
  return (UART0.LSR & LSR_RDR_MASK);
}

int serial_output_ready(void)
{
  return (UART0.LSR & LSR_THRE_MASK );
}

unsigned char serial_getchar(void)
{
  while (!(UART0.LSR & LSR_RDR_MASK));     // wait for character to be received
  return UART0.RBR;
}

void serial_putchar(unsigned char c)
{
  while (!(UART0.LSR & LSR_THRE_MASK));  // wait for space in transmitter
  UART0.THR = c;
}

void serial_puts(unsigned char *s)     // send a string
{
  while(*s) serial_putchar( *s++ );
}


