// print.h : minimal output routines for printing numbers to the basic console
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// Some minimal utilities for printing numbers to the console.

#ifndef PRINT_H_INCLUDED
#define PRINT_H_INCLUDED

#include <integers.h>

extern void print_binary_byte( UINT8 c);
extern void print_binary_short( UINT16 i );
extern void print_binary_int( UINT32 i );

extern void print_hex_digit( UINT8 c  );  	// output a single hex digit
extern void print_hex_byte ( UINT8 c  );  	// output a pair of hex digits
extern void print_hex_short( UINT16 i );  	// output a short
extern void print_hex_int  ( UINT32 i );  	// output an integer

extern void print_decimal_uint( UINT32 input ); // output an unsigned decimal number
extern void print_decimal_int( INT32 input );   // output a signed decimal number

#endif //  PRINT_H_INCLUDED
