// posix-serial-port.h : interface to a POSIX standard serial port on a host computer
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#ifndef __POSIX_SERIAL_PORT_H_INCLUDED__
#define __POSIX_SERIAL_PORT_H_INCLUDED__

#include <stdio.h>

extern int serial_set_raw_mode( int fd );
extern int serial_set_baud_rate(int fd, int rate);
extern int serial_get_input_baud_rate( int fd );
extern int serial_get_output_baud_rate( int fd );

// Convenience routines for opening a port using libc I/O.
extern int open_posix_serial_port_in_raw_mode( char *serial_port_name, int baud_rate, FILE **in, FILE **out);

// This may eventually include a libstd port interface to the serial port.

#endif /*  __POSIX_SERIAL_PORT_H_INCLUDED__ */



