// interrupt_handlers.h : definitions for common symbols defined by multiple interrupt handler routines
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// Definitions for public variables affected by the interrupt handlers.

#ifndef __INTERRUPT_HANDLERS_H_INCLUDED__
#define __INTERRUPT_HANDLERS_H_INCLUDED__

extern void default_IRQ_handler(void);

#if CONFIG_TIMER_INTERRUPT_RATE
extern void timer_interrupt_handler(void);

#if CONFIG_TIMER_INTERRUPT_REPORTS_LOAD
// holds the timer counter value near the end of the timer interrupt
extern volatile unsigned int timer_interrupt_load_indicator;  
extern volatile unsigned int timer_interrupt_max_load;
#endif

#endif

#if CONFIG_WATCHDOG_GENERATES_INTERRUPT
extern volatile unsigned int watchdog_interrupts;
extern volatile unsigned int watchdog_stack_trace_length;
extern volatile unsigned int watchdog_stack_trace[];
extern volatile unsigned int watchdog_stack_base;
extern volatile unsigned int watchdog_interrupt_return_address;
extern void watchdog_interrupt_handler(void);
#endif

#endif // __INTERRUPT_HANDLERS_H_INCLUDED__
