// fast_interrupt_handlers.c : default interrupt handler for spurious FIQ interrupts
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#include <libLPC2xxx.h>

// Default FIQ handler.  GCC is smart enough not to save/restore
// registers r8-r13, which are specially banked for FIQ handlers.
// The compiler option -ffixed-r0 -ffixed-r1 -ffixed-r2 etc.
// can keep it from using the lower registers, by treating them as
// globally allocated registers.

// Keep some statistics.
volatile unsigned int FIQ_count = 0;

void __attribute__((interrupt ("FIQ"))) default_FIQ_handler(void)
{
  FIQ_count++;

  // Disable any hardware-triggered FIQ to prevent retriggering.
  VIC.IntEnClear = VIC.FIQStatus & ~VIC.SoftInt;

  // Reset any software-triggered FIQ.
  VIC.SoftIntClear = VIC.FIQStatus;
}

/****************************************************************/
// GCC allows global register variable allocation, which might
// be a way to force the FIQ handler to not use the lower numbered
// registers when it can use r8-r13 for free.
#if 0
register int *r0_allocate asm ("r0");
register int *f1_allocate asm ("r1");
register int *r2_allocate asm ("r2");
register int *r3_allocate asm ("r3");
register int *r4_allocate asm ("r4");
register int *r5_allocate asm ("r5");
register int *r6_allocate asm ("r6");
register int *r7_allocate asm ("r7");
#endif


