// console.h : a very simple character console output interface
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// This provides a sort of trivial stdio package which can be
// configured to use UART0 in either a buffered and polled or unbuffered
// way.  This is more minimal than using the libstd port functions.

#ifndef CONSOLE_H_INCLUDED
#define CONSOLE_H_INCLUDED

// These assume a terminal output; \n is expanded to \r\n
extern int putchar( int c);
extern int puts(const char *str);

extern int getchar( void );
extern int char_ready_p(void);

// These are obsolete.
extern void printc( int c );
extern void prints( const char *str );

#endif // CONSOLE_H_INCLUDED

