// UART1_interrupt_handler.h : interrupt handler for the second serial port
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#ifndef UART1_INTERUPT_HANDLER_DEFINED
#define UART1_INTERUPT_HANDLER_DEFINED

// None of these functions block.
extern int UART1_fifo_read_ready(void);                // returns true if data is available in the input buffer
extern int UART1_fifo_write_ready(void);               // returns true if space is available in the output buffer
extern int UART1_fifo_read_char(void);                 // will return EOF if nothing available
extern int UART1_fifo_write_char(unsigned char c);     // will return an error if the buffer is full

extern void UART1_install_interrupt(void);             // install the interrupt handler; this doesn't initialize the UART

#endif // UART1_INTERUPT_HANDLERS_DEFINED
