// ADC.c : interface to LPC2xxx on-chip A/D converters
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#include <libLPC2xxx.h>
#include <ADC.h>

// Some basic polled conversion routines.  It is also possible
// for the hardware to generate an interrupt by enabling a bit in the
// VIC.

// The manual is inconsistent on whether the A/D multiplexer inputs
// connect to the pins when the pins are not configured for analog
// input.  It appears from testing that the multiplexer is
// disconnected when the pins are configured for digital input or
// output.  However, the multiplexer is connected when the pin is
// configured for analog output.  On the LPC2138, this only applies to
// ADC0.4, which shares pin P0.25 with the analog output.

void ADC_start_conversion( struct ADC_registers_t *ADC, int channel )
{
  ADC->ADCR = ( ( 1 << channel ) |                 // channel select bitfield
	       ( ADC_CLOCK_DIVISOR << 8 ) |        // A/D clock = PCLK / (CLKDIV+1); this rounds down by 
	       0 |                                // BURST = 0
	       0 |                                // CLKS  = 0
	       ADCR_PDN_MASK |                    // enable converter
	       ( 1 << 24 ) |                      // start now
	       0 );                               // EDGE = 0
}

// Reading the DONE bit has the side effect of clearing it.
int ADC_is_data_ready( struct ADC_registers_t *ADC )
{
  return ( ADC->ADDR & ADDR_DONE_MASK );
}

int ADC_read_result( struct ADC_registers_t *ADC )
{
  // this assumes that the DONE bit was previously detected
  return (( ADC->ADDR & ADDR_DATA_MASK ) >> ADDR_DATA_SHIFT );
}

