// sabertooth.h : definitions for an interface to a Dimension Engineering Sabertooth 2x10 motor amplifier
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

// The Sabertooth 2x10 controls two brushed DC motors.  This driver
// uses the packetized serial mode using UART1 to send motor commands
// to the driver.  This assumes the driver DIP switches are set as
// follows:
//
// DIP switches (DOWN == OFF):
//   1  :  DOWN    (mode 4)
//   2  :  DOWN    (mode 4)
//   3  :  UP      (no lithium cutoff, using NiMH cells)
//   4  :  UP      (address 128)
//   5  :  UP      (address 128)
//   6  :  UP      (address 128)

#ifndef SABERTOOTH_H_INCLUDED
#define SABERTOOTH_H_INCLUDED

#include <libLPC2xxx.h>
#include <libstd.h>
#include <timing.h>

/****************************************************************/
// Global state structure for the Sabertooth.

extern struct sabertooth_t {
  int command1, command2;
  elapsed_timer timer;
  int initialized;
} sabertooth;

// API functions.
extern int init_sabertooth(void);
extern int sabertooth_command( int channel, int value );

// This function should be called periodically from the main event
// loop to manage any internal state.
extern int sabertooth_update(void);

/****************************************************************/
#endif // SABERTOOTH_INCLUDED
