// imu.h : definitions for an interface to a Spark Fun 5DOF analog IMU
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

// The Spark Fun 5DOF IMU measures two angular rates and three linear
// accelerations.  This driver uses the LPC2103 A/D converter to
// sample these values on the timer interrupt, and performs simple
// filtering to reduce noise.

#ifndef IMU_H_INCLUDED
#define IMU_H_INCLUDED

#include <libLPC2xxx.h>
#include <libstd.h>

/****************************************************************/
// Global state structure for the IMU; some values are updated
// during timer interrupt processing.

// The sensor values are stored in a fixed point format with the
// following number of bits in the fraction:
#define IMU_MANTISSA 21    // signed 10.21 fixed point

extern struct imu_t {
  volatile fixed_point_t raw_sample[5];   // raw A/D value
  volatile fixed_point_t zeropoint[5];    // the estimate of the DC level of each channel
  volatile fixed_point_t value[5];        // filtered angular rates or linear accelerations
  volatile unsigned samples;

} imu;

// Interrupt update function.
extern void imu_poll(void);

// API functions.
extern int init_imu(void);

/****************************************************************/
#endif // IMU_INCLUDED
