// config.h : library source code configuration file for the Balancer controller
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

// Configuration of the specific hardware and software environment for
// compiling the entire body of code for a specific target.  This
// allows both the LPC2xxx library and application code to be
// customized.
//
// The overall order of inclusion in any given source file should be:
//   config.h		this file
//     LPC2103.h	the CPU hardware variant
//        lpc2xxx.h	the generic CPU definition
//   libstd.h		the hardware-independent support library
//   libLPC2xxx.h	the hardware interface support library

/****************************************************************/ 
#ifndef __CONFIG_H_INCLUDED__
#define __CONFIG_H_INCLUDED__

/****************************************************************/
// Configure the libraries for the Olimex LPC-P2103 Prototyping board.
// The board includes a female DB9 and MAX3232 driver connected to
// UART0.  On this machine the board has a daughterboard attached to
// pin out specific signals for the Spark Fun 5DOF IMU, motor
// encoders, and motor amplifier.

#ifdef TARGET_OP03
#include <LPC2103.h>

// The Olimex LPC-P2103 board has a green LED on P0.26
#define CONFIG_CPU_LED_MASK  (0x04000000)  
#define CONFIG_CPU_LED_GPIO  GPIO0

// The Olimex LPC-P2103 board has a button on P0.15
#define CONFIG_BUTTON1_MASK  (0x00008000)  
#define CONFIG_BUTTON1_GPIO  GPIO0

#endif  // TARGET_OP03

/****************************************************************/
// A generic unix host.
#ifdef TARGET_POSIX
#define LIBSTD_USE_SYSTEM_C_DEFINITIONS 1
#endif


/****************************************************************/
// Here is the application-specific configuration settings for the
// libraries.

#define CONFIG_TIMER_INTERRUPT_RATE 50000
#define CONFIG_INSTALL_DEFAULT_TIMER_INTERRUPT 0

#define CONFIG_CONSOLE_BAUD 115200
#define CONFIG_UART0_OUTPUT_BUFLEN 1024

// Define the serial port settings for the motor amplifier serial link.
#define CONFIG_UART1_BAUD  38400
#define CONFIG_UART1_OUTPUT_BUFLEN 256
#define CONFIG_UART_PORT_SUPPORTS_UART1 1

#define LIBSTD_FORMAT_SUPPORTS_BINARY 1
#define LIBSTD_FORMAT_SUPPORTS_FIXED  1

#endif //  __CONFIG_H_INCLUDED__

/****************************************************************/
