// string_port.h : interface to fixed sized string buffer using port abstraction
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#ifndef STRING_PORT_H_INCLUDED
#define STRING_PORT_H_INCLUDED

#include <libstd.h>

// This is public only so it can be statically allocated, it should
// only be manipulated with the port functions.
struct string_port_t {
  struct port_t interface;     // the standard port interface, must be first
  unsigned char *buffer;       // the fixed size memory buffer
  size_t buffer_size;          // the size of it
  size_t characters;           // the number of characters in use
  size_t position;             // the read or write position
};

// A safe function for making sure that the underlying buffer of a
// writable string port is a proper zero-terminated C string.  Returns
// zero on success; if the buffer is completely full, this
// zero-terminates it by overwriting a character, and returns an error
// code.
extern int string_port_zero_terminate( string_port *strport );

#endif
