// port.h : abstract interface to character devices a la Scheme
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

#ifndef __PORT_H_DEFINED__
#define __PORT_H_DEFINED__

#include <libstd.h>

// The somewhat opaque definition of the port class.  This should only
// used by definitions of specialized ports, as it is likely to
// change.

struct port_class_t {
  int  (*read_char)(struct port_t *p);
  int  (*peek_char)(struct port_t *p);
  int  (*char_ready)(struct port_t *p);
  int  (*write_char)(struct port_t *p, int c);
  size_t  (*read)(struct port_t *p, void *buf, size_t nbytes);
  size_t (*write)(struct port_t *p, void *buf, size_t nbytes);
  off_t   (*seek)(struct port_t *p, off_t offset, int whence);
  int    (*close)(struct port_t *p);
};

extern void generic_port_init( struct port_t *p, const struct port_class_t *methods, unsigned mode );
extern int  generic_port_peek_char( struct port_t *p );

#endif // __PORT_H_DEFINED__
