// print.c : minimal output routines for printing numbers to the basic console
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// This is kind of a barebones text output package.  It depends upon a
// single external function which sends characters out to whatever
// device the user chooses.

#include <print.h>
#include <console.h>

// output a single hex digit
void print_hex_digit( UINT8 c)
{
  c &= 0x0f;
  if (c > 9) putchar(c + 'A' - 10);
  else putchar(c + '0');
}

// output a pair of hex digits
void print_hex_byte( UINT8 c)
{
  print_hex_digit(c >> 4);
  print_hex_digit(c & 0xf);
}

// output an integer
void print_hex_short( UINT16 i )
{
  print_hex_byte( (i >> 8) & 0xff );
  print_hex_byte(     i    & 0xff );
}

// output an integer
void print_hex_int( UINT32 i )
{
  print_hex_short( (i >> 16) & 0xffff );
  print_hex_short(     i     & 0xffff);
}

// output an integer
void print_decimal_uint( UINT32 input )
{
  int i;
  char tmp[10];  // max int is ~4E9

  // the digits are created in reverse order
  for ( i = 0; i < 10; i++ ) {
    tmp[i] = '0' + input % 10;  // generate one digit
    input /= 10;
    if ( input == 0) break;
  }
  // output the digits
  while ( i >= 0 ) putchar(tmp[i--]);
}
// output a signed decimal number
void print_decimal_int( INT32 input )
{
  if ( input < 0 ) {
    putchar('-');
    input = -input;
  }
  print_decimal_uint( input );
}

// output 8 bits
void print_binary_byte( UINT8 c)
{
  UINT8 mask = 0x80;
  while (mask) {
    putchar ( (c & mask) ? '1' : '0');
    mask >>=1;
  }
}
// output an integer
void print_binary_short( UINT16 i )
{
  print_binary_byte( (i >> 8) & 0xff );
  print_binary_byte(     i    & 0xff );
}

// output an integer
void print_binary_int( UINT32 i )
{
  print_binary_short( (i >> 16) & 0xffff );
  print_binary_short(     i     & 0xffff);
}
