// polled_serial.h : FIFO wrapper for the basic serial console, usable from interrupt context
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// A simple FIFO wrapper around the basic serial console.  This is
// useful for either timer interrupt driven systems which poll the
// serial port or non-interrupt driven systems which benefit from
// buffering and can guarantee a sufficient polling rate.

#ifndef POLLED_SERIAL_H_INCLUDED
#define POLLED_SERIAL_H_INCLUDED

#include <fifo.h>
extern void serial_output_poll(void);
extern void serial_input_poll(void);
extern fifo serial_input_fifo;
extern fifo serial_output_fifo;

#endif //  POLLED_SERIAL_H_INCLUDED
