// polled_serial.c : FIFO wrapper for the basic serial console, usable from interrupt context
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#include <libLPC2xxx.h>
#include <libstd.h>
#include <polled_serial.h>

// Define the UART I/O buffers
static unsigned char serial_output_buffer[ CONFIG_UART0_OUTPUT_BUFLEN ];
fifo serial_output_fifo = { &serial_output_buffer, CONFIG_UART0_OUTPUT_BUFLEN, 0, 0 };

static unsigned char serial_input_buffer[ CONFIG_UART0_INPUT_BUFLEN ];
fifo serial_input_fifo = { &serial_input_buffer, CONFIG_UART0_INPUT_BUFLEN, 0, 0 };

void serial_output_poll(void)
{
  // Poll UART0 output. Check transmitter empty flag; if space is available check hardware output FIFO.
  if  (UART0.LSR & LSR_THRE_MASK ) {              // output ready to send
    int c = fifo_getchar( &serial_output_fifo );  // this is the software fifo buffer for storing output
    // if the buffer isn't empty, send a character
    if ( c != EOF ) UART0.THR = (unsigned char) c; 
  }
}
void serial_input_poll(void)
{
  // Poll UART0 input. Check data ready flag, put any data into input FIFO.
  if ( UART0.LSR & LSR_RDR_MASK) {
    unsigned char data = UART0.RBR;  // read a new datum

    // This will try putting new data into the buffer, and ignore any overrun.
    fifo_putchar( &serial_input_fifo, data );
  }
}
