// interrupt_control.h : utility routines to enable and disable interrupts
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
#ifndef INTERRUPT__CONTROL_H_INCLUDED
#define INTERRUPT__CONTROL_H_INCLUDED

#include <integers.h>

// If enabled, disables all FIQ and IRQ interrupts, saving the previous state.
extern void save_and_disable_interrupt_state ( UINT32 *state );

// Restore the values of the FIQ and IRQ mask bits from a saved state.
extern void restore_interrupt_state ( UINT32 *state );

#endif // INTERRUPT__CONTROL_H_INCLUDED

