// errcodes.h : global error code definitions for all of ArtLPC.
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// For now, all error codes.  I am testing the philosophy of making
// error codes as specific as possible, so that a single integer might
// deliver the maximum information about the point of failure.

enum {
  // Generic error codes.  Some of these are for libstd functions.
  ERRNOERROR = 0,
  // -1 is reserved for EOF
  ERRGENERIC = 2,    // some kind of universal error, should generally be made more specific
  ERRNULLPTR,
  ERRAGAIN,         // this should be replaced
  ERRINVAL,         // this should be replaced
  ERRNOSPACE,
  ERRIOERROR,
  ERRNOSYS,
  ERRREADONLY,

  BLOCK_DEVICE_NULL_DEV = 100,
  BLOCK_DEVICE_NULL_BUFFER,
  BLOCK_DEVICE_UNINITIALIZED,
  BLOCK_DEVICE_CLOSED,
  BLOCK_DEVICE_READ_ONLY,

  PARTITION_DEVICE_NULL_PTR = 200,
  PARTITION_DEVICE_BAD_ADDRESS,
  PARTITION_DEVICE_UNREADABLE_MBR,
  PARTITION_DEVICE_INVALID_MBR,
  PARTITION_DEVICE_UNSUPPORTED_TYPE,

  MEMBLOCK_DEVICE_NULL_PTR = 300,
  MEMBLOCK_DEVICE_BAD_ADDRESS,

  MMAP_BLOCK_DEVICE_NULL_PTR = 350,
  MMAP_BLOCK_DEVICE_BAD_ADDRESS,

  FAT16_FILESYSTEM_NULL_FS = 400,
  FAT16_FILESYSTEM_NULL_DEV,
  FAT16_FILESYSTEM_NULL_DIRENT,
  FAT16_FILESYSTEM_NULL_FILE,
  FAT16_FILESYSTEM_UNREADABLE_BOOTSECTOR,

  FAT16_FILESYSTEM_INVALID_SECTOR_SIZE,
  FAT16_FILESYSTEM_INVALID_FAT_COUNT,
  FAT16_FILESYSTEM_INVALID_BS_MARKER,
  FAT16_FILESYSTEM_INVALID_FS_NAME,
  FAT16_FILESYSTEM_INVALID_DIRECTORY_INDEX,

  FAT16_FILESYSTEM_INVALID_CLUSTER_INDEX,   // 410
  FAT16_FILESYSTEM_UNREADABLE_DIRECTORY,
  FAT16_FILESYSTEM_UNWRITABLE_DIRECTORY,
  FAT16_FILESYSTEM_UNREADABLE_FAT,
  FAT16_FILESYSTEM_UNWRITABLE_FAT,

  FAT16_FILESYSTEM_FILE_NOT_FOUND,         // 415
  FAT16_FILESYSTEM_DIRECTORY_FULL,
  FAT16_FILESYSTEM_INSUFFICIENT_SPACE,
  FAT16_FILESYSTEM_INVALID_CHAIN_LENGTH,
  FAT16_FILESYSTEM_CORRUPT_CLUSTER_CHAIN,

  FAT16_FILESYSTEM_FILE_ALREADY_EXISTS,   // 420
  FAT16_FILESYSTEM_END_OF_DIRECTORY,
  FAT16_FILESYSTEM_UNALLOCATED_CLUSTER,
  FAT16_FILESYSTEM_INVALID_FILE_POSITION,
  FAT16_FILESYSTEM_READ_ONLY,


  FAT16_FILE_NULL_DEV = 500,
  FAT16_FILE_NULL_BUFFER,
  FAT16_FILE_EOF,

  // SPI-MMC driver error codes 
  MMC_IDLE_STATE_TIMEOUT = 600,
  MMC_IDLE_STATE_ERROR,
  MMC_OP_COND_TIMEOUT,
  MMC_SET_BLOCKLEN_TIMEOUT,
  MMC_READ_BLOCK_TIMEOUT,
  MMC_READ_BLOCK_ERROR,
  MMC_READ_BLOCK_DATA_TIMEOUT,
  MMC_READ_BLOCK_DATA_ERROR,
  MMC_READ_CSD_TIMEOUT,
  MMC_READ_CSD_DATA_TIMEOUT,
  MMC_READ_CID_TIMEOUT,
  MMC_READ_CID_DATA_TIMEOUT,
  MMC_WRITE_BLOCK_TIMEOUT,
  MMC_WRITE_BLOCK_ERROR,
  MMC_WRITE_BLOCK_DATA_TIMEOUT,
  MMC_WRITE_BLOCK_DATA_ERROR,
  MMC_WRITE_BLOCK_BUSY_TIMEOUT,
  MMC_READ_ONLY,

  // SPI-MMC block device error codes
  MMC_BLOCK_DEVICE_NULL_PTR = 700,
  MMC_BLOCK_DEVICE_BAD_ADDRESS,

  // sequential file de-blocker error codes
  // now obsolete
  // SEQ_FILE_NULL_FILE = 800,
  // SEQ_FILE_NULL_DEV,
  // SEQ_FILE_NULL_BUFFER,
  // SEQ_FILE_EOF,

  // wav audio file parser error codes
  WAV_AUDIO_NULL_WAV = 900,
  WAV_AUDIO_NULL_FILE,
  WAV_AUDIO_NULL_BUFFER,
  WAV_AUDIO_UNREADABLE_HEADER,
  WAV_AUDIO_INVALID_FILE_ID,
  WAV_AUDIO_INVALID_FILE_FORMAT,
  WAV_AUDIO_INVALID_DATA_SIZE,
  WAV_AUDIO_UNREADABLE_CHUNK,
  WAV_AUDIO_INVALID_FMT_SIZE,
  WAV_AUDIO_UNREADABLE_FORMAT,
  WAV_AUDIO_FILE_NOT_PCM,
  WAV_AUDIO_FILE_NOT_MONO,
  WAV_AUDIO_INVALID_SAMPLE_RATE,
  WAV_AUDIO_INVALID_ALIGNMENT,
  WAV_AUDIO_INVALID_DEPTH,
  WAV_AUDIO_FORMAT_MISSING,

  // QT117 capacitance sensor driver
  QT117_CYCLE_TIMED_OUT = 1000,
  QT117_BAD_TRANSFER_COUNT,
  QT117_PREMATURE_FRAME_END,

  LAST_ERROR_CODE
};
