// default_interrupts.c : interrupt handler for spurious interrupts
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// Default interrupt handlers
#include <libLPC2xxx.h>
#include <interrupt_handlers.h>

volatile unsigned spurious_interrupt_count = 0;
volatile unsigned spurious_interrupt_mask;
volatile unsigned spurious_interrupt_status;

// Permissible values for the "interrupt" attribute parameter are:
// IRQ, FIQ, SWI, ABORT and UNDEF. This behavior changed with GCC 3.4.4.

/****************************************************************/
// This could be called during either a non-vectored interrupt or a
// spurious interrupt.

void __attribute__((interrupt)) default_IRQ_handler(void)
{
  // On an unexpected IRQ, the basic strategy is to disable the
  // source.  If this causes some essential hardware to stall, maybe
  // the watchdog will eventually rescue the system.

  spurious_interrupt_count++;
  spurious_interrupt_mask   = VIC.RawIntr;
  spurious_interrupt_status = VIC.IRQStatus;

  // Disable any hardware-triggered IRQ to prevent retriggering.
  VIC.IntEnClear = VIC.IRQStatus & ~VIC.SoftInt;

  // Reset any software-triggered IRQ.
  VIC.SoftIntClear = VIC.IRQStatus;

  // A write must be performed to the VIC Vector Address Register to
  // update the VIC priority hardware.
  VIC.VectAddr = 0;
}

/****************************************************************/


