// console.c : a very simple character console output interface
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------

// A kind of trivial stdio package for the default console.  This
// provides getchar(), putchar(), etc., and can be configured to use
// one of several low-level implementations of the serial port driver.
// The unbuffered version uses serial_console.c for I/O, and the
// buffered version uses the FIFO buffers from polled_serial.c which are
// normally polled from the timer interupt.

// The UART_*port drivers provide a more abstract interface as a
// general character device, and have the option of supporting UART
// device interrupts.

#include <libstd.h>
#include <libLPC2xxx.h>
#include <serial_console.h>
#include <console.h>
#include <polled_serial.h>
#include <errcodes.h>

/****************************************************************/
#if CONSOLE_USES_SERIAL_FIFOS
static void _putchar( int c)
{
#if TIMER_INTERRUPT_UPDATES_POLLED_SERIAL_FIFOS
  while ( -ERRAGAIN == fifo_putchar( &serial_output_fifo, c ));
#else
  fifo_putchar( &serial_output_fifo, c);
#endif
}

// provide a basic blocking getchar
int getchar(void)
{
  int c;
  do {
    c = fifo_getchar( &serial_input_fifo );
  } while ( c == EOF );
  return c;
}
// check for data
int char_ready_p(void)
{
  return (fifo_data_available( &serial_input_fifo ) > 0);
}
#endif

/****************************************************************/
#if CONSOLE_USES_UNBUFFERED_SERIAL
static void _putchar( int c)
{
  serial_putchar( c );
}
int getchar( void )
{
  return (int) serial_getchar();
}
int char_ready_p(void)
{
  return serial_input_ready();
}
#endif

/****************************************************************/
/****************************************************************/
int putchar( int c)
{
  if ( c == '\n' ) _putchar( '\r' );
  _putchar( c );
  return c;
}

int puts(const char *str)
{
  while(*str) putchar( *str++ );
  return 0;
}

/****************************************************************/
// These are obsolete.
void printc( int c)
{
  putchar(c);
}

void prints(const char *str)
{
  puts(str);
}

/****************************************************************/
// Input.

// #if CONSOLE_INPUT_LINE_BUFFERED
// static unsigned char input_buffer[ CONSOLE_INPUT_LINE_BUFFER_SIZE ];
// static unsigned input_buffer_chars;
// static unsigned input_available;

// int getchar( void )
// {
//   if ( input_available ) {
//    unsigned char 

