// UART_port.h : character device interface to interrupt driven serial ports
// Copyright (c) 2005-2007 Garth Zeglin

// This file is part of ArtLPC. 

// ArtLPC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// ArtLPC is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ArtLPC; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

// ---------------------------------------------------------------------
// A port abstraction for a interrupt driven buffered UART.

#ifndef __UART_PORT_H_DEFINED__
#define __UART_PORT_H_DEFINED__

#include <libstd.h>
#include <LPC2xxx.h>

// This is public only so it can be statically allocated, it should
// only be manipulated with the port functions.
typedef struct UART_port_t {
  struct port_t interface;     // the standard port interface, must be first

  // struct UART_registers_t *uart;
} UART_port;

// Initialize a port structure for a serial port and the underlying hardware.
// A typical mode for a console port is (PORT_FLAGS_READ|PORT_FLAGS_WRITE|PORT_FLAGS_CRLF).
// The divisor is the clock divisor which determines the baud rate.
extern int UART_port_init( UART_port *p, struct UART_registers_t *uart, unsigned divisor, unsigned mode );

#endif // __UART_PORT_H_DEFINED__
